/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.singleobjective.evolutionstrategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractEvolutionStrategy;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ObjectiveComparator;

public class NonElitistEvolutionStrategy<S extends Solution<?>>
extends AbstractEvolutionStrategy<S, S> {
    private int mu;
    private int lambda;
    private int maxEvaluations;
    private int evaluations;
    private MutationOperator<S> mutation;
    private Comparator<S> comparator;

    public NonElitistEvolutionStrategy(Problem<S> problem, int mu, int lambda, int maxEvaluations, MutationOperator<S> mutation) {
        super(problem);
        this.mu = mu;
        this.lambda = lambda;
        this.maxEvaluations = maxEvaluations;
        this.mutation = mutation;
        this.comparator = new ObjectiveComparator(0);
    }

    @Override
    protected void initProgress() {
        this.evaluations = 1;
    }

    @Override
    protected void updateProgress() {
        this.evaluations += this.lambda;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    @Override
    protected List<S> createInitialPopulation() {
        ArrayList<Solution> population = new ArrayList<Solution>(this.mu);
        for (int i = 0; i < this.mu; ++i) {
            Solution newIndividual = (Solution)this.getProblem().createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    @Override
    protected List<S> evaluatePopulation(List<S> population) {
        for (Solution solution : population) {
            this.getProblem().evaluate(solution);
        }
        return population;
    }

    @Override
    protected List<S> selection(List<S> population) {
        return population;
    }

    @Override
    protected List<S> reproduction(List<S> population) {
        ArrayList offspringPopulation = new ArrayList(this.lambda);
        for (int i = 0; i < this.mu; ++i) {
            for (int j = 0; j < this.lambda / this.mu; ++j) {
                Solution offspring = ((Solution)population.get(i)).copy();
                this.mutation.execute(offspring);
                offspringPopulation.add(offspring);
            }
        }
        return offspringPopulation;
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        Collections.sort(offspringPopulation, this.comparator);
        ArrayList<S> newPopulation = new ArrayList<S>(this.mu);
        for (int i = 0; i < this.mu; ++i) {
            newPopulation.add(offspringPopulation.get(i));
        }
        return newPopulation;
    }

    @Override
    public S getResult() {
        return (S)((Solution)this.getPopulation().get(0));
    }

    @Override
    public String getName() {
        return "NonElitistEA";
    }

    @Override
    public String getDescription() {
        return "Non Elitist Evolution Strategy Algorithm, i.e, (mu , lambda) EA";
    }
}

