/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.UF;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class UF9
extends AbstractDoubleProblem {
    double epsilon;

    public UF9() {
        this(30, 0.1);
    }

    public UF9(int numberOfVariables, double epsilon) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(3);
        this.setNumberOfConstraints(0);
        this.setName("UF9");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        this.epsilon = epsilon;
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 2; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-2.0);
            upperLimit.add(2.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        double yj;
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        double sum3 = 0.0;
        double sum2 = 0.0;
        double sum1 = 0.0;
        int count3 = 0;
        int count2 = 0;
        int count1 = 0;
        for (int j = 3; j <= this.getNumberOfVariables(); ++j) {
            yj = x[j - 1] - 2.0 * x[1] * Math.sin(Math.PI * 2 * x[0] + (double)j * Math.PI / (double)this.getNumberOfVariables());
            if (j % 3 == 1) {
                sum1 += yj * yj;
                ++count1;
                continue;
            }
            if (j % 3 == 2) {
                sum2 += yj * yj;
                ++count2;
                continue;
            }
            sum3 += yj * yj;
            ++count3;
        }
        yj = (1.0 + this.epsilon) * (1.0 - 4.0 * (2.0 * x[0] - 1.0) * (2.0 * x[0] - 1.0));
        if (yj < 0.0) {
            yj = 0.0;
        }
        solution.setObjective(0, 0.5 * (yj + 2.0 * x[0]) * x[1] + 2.0 * sum1 / (double)count1);
        solution.setObjective(1, 0.5 * (yj - 2.0 * x[0] + 2.0) * x[1] + 2.0 * sum2 / (double)count2);
        solution.setObjective(2, 1.0 - x[1] + 2.0 * sum3 / (double)count3);
    }
}

