/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.wasfga.WASFGA;
import org.uma.jmetal.operator.impl.crossover.PMXCrossover;
import org.uma.jmetal.operator.impl.mutation.PermutationSwapMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.multiobjective.MultiobjectiveTSP;
import org.uma.jmetal.solution.PermutationSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class WASFGARunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, IOException {
        MultiobjectiveTSP problem = new MultiobjectiveTSP("/tspInstances/kroA100.tsp", "/tspInstances/kroB100.tsp");
        PMXCrossover crossover = new PMXCrossover(0.9);
        double mutationProbability = 0.2;
        PermutationSwapMutation mutation = new PermutationSwapMutation(mutationProbability);
        BinaryTournamentSelection selection = new BinaryTournamentSelection(new RankingAndCrowdingDistanceComparator());
        String referenceParetoFront = "";
        ArrayList<Double> referencePoint = null;
        problem = new MultiobjectiveTSP("/tspInstances/kroA100.tsp", "/tspInstances/kroB100.tsp");
        referencePoint = new ArrayList<Double>();
        referencePoint.add(0.0);
        referencePoint.add(0.0);
        double epsilon = 0.01;
        WASFGA<PermutationSolution<Integer>> algorithm = new WASFGA<PermutationSolution<Integer>>(problem, 100, 250, crossover, mutation, selection, new SequentialSolutionListEvaluator(), epsilon, referencePoint);
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        WASFGARunner.printFinalSolutionSet(population);
        if (!referenceParetoFront.equals("")) {
            WASFGARunner.printQualityIndicators(population, referenceParetoFront);
        }
    }
}

