/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.espea;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractGeneticAlgorithm;
import org.uma.jmetal.algorithm.multiobjective.espea.util.EnergyArchive;
import org.uma.jmetal.algorithm.multiobjective.espea.util.ScalarizationWrapper;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class ESPEA<S extends Solution<?>>
extends AbstractGeneticAlgorithm<S, List<S>> {
    protected int evaluations;
    protected int maxEvaluations;
    protected CrossoverOperator<S> fullArchiveCrossoverOperator;
    protected final SolutionListEvaluator<S> evaluator;
    protected final EnergyArchive<S> archive;

    public ESPEA(Problem<S> problem, int maxEvaluations, int populationSize, CrossoverOperator<S> crossoverOperator, CrossoverOperator<S> fullArchiveCrossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, ScalarizationWrapper scalarizationWrapper, SolutionListEvaluator<S> evaluator, boolean normalizeObjectives, EnergyArchive.ReplacementStrategy replacementStrategy) {
        super(problem);
        this.maxEvaluations = maxEvaluations;
        this.setMaxPopulationSize(populationSize);
        this.crossoverOperator = crossoverOperator;
        this.fullArchiveCrossoverOperator = fullArchiveCrossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = selectionOperator;
        this.archive = new EnergyArchive(populationSize, scalarizationWrapper, normalizeObjectives, replacementStrategy);
        this.evaluator = evaluator;
    }

    @Override
    public String getName() {
        return "ESPEA";
    }

    @Override
    public String getDescription() {
        return "Electrostatic Potential Energy Evolutionary Algorithms";
    }

    @Override
    protected void initProgress() {
        this.evaluations = this.getMaxPopulationSize();
        this.population.forEach(s -> this.archive.add((Solution)s));
    }

    @Override
    protected void updateProgress() {
        ++this.evaluations;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    @Override
    protected List<S> evaluatePopulation(List<S> population) {
        population = this.evaluator.evaluate(population, this.getProblem());
        return population;
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        offspringPopulation.forEach(s -> this.archive.add((Solution)s));
        return this.archive.getSolutionList();
    }

    @Override
    public List<S> getResult() {
        return this.archive.getSolutionList();
    }

    @Override
    protected List<S> selection(List<S> population) {
        CrossoverOperator chosenOperator = this.archive.isFull() ? this.fullArchiveCrossoverOperator : this.crossoverOperator;
        ArrayList<Solution> matingPopulation = new ArrayList<Solution>(chosenOperator.getNumberOfRequiredParents());
        for (int i = 0; i < chosenOperator.getNumberOfRequiredParents(); ++i) {
            Solution solution = (Solution)this.selectionOperator.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    @Override
    protected List<S> reproduction(List<S> population) {
        List offspring = (List)this.crossoverOperator.execute(population);
        this.mutationOperator.execute(offspring.get(0));
        return offspring;
    }
}

