/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.espea.util;

import java.util.Collections;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.espea.util.AchievementScalarizationComparator;
import org.uma.jmetal.algorithm.multiobjective.espea.util.ScalarizationValue;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.extremevalues.impl.FrontExtremeValues;
import org.uma.jmetal.util.front.imp.ArrayFront;

public class ScalarizationUtils {
    private static <S extends Solution<?>> void setScalarizationValue(S solution, double scalarizationValue) {
        solution.setAttribute(new ScalarizationValue().getAttributeIdentifier(), scalarizationValue);
    }

    private static <S extends Solution<?>> double getScalarizationValue(S solution) {
        return (Double)solution.getAttribute(new ScalarizationValue().getAttributeIdentifier());
    }

    private static double[] toArray(List<Double> list) {
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = list.get(i);
        }
        return values;
    }

    private static <S extends Solution<?>> double[] getIdealValues(List<S> solutionsList) {
        ArrayFront front = new ArrayFront(solutionsList);
        FrontExtremeValues extremeValues = new FrontExtremeValues();
        List<Double> list = extremeValues.findLowestValues(front);
        return ScalarizationUtils.toArray(list);
    }

    private static <S extends Solution<?>> double[] getNadirValues(List<S> solutionsList) {
        ArrayFront front = new ArrayFront(solutionsList);
        FrontExtremeValues extremeValues = new FrontExtremeValues();
        List<Double> list = extremeValues.findHighestValues(front);
        return ScalarizationUtils.toArray(list);
    }

    private static <S extends Solution<?>> double[][] getExtremePoints(List<S> solutionsList) {
        double[][] extremePoints = new double[((Solution)solutionsList.get(0)).getNumberOfObjectives()][];
        for (int i = 0; i < extremePoints.length; ++i) {
            Solution extreme = (Solution)Collections.min(solutionsList, new AchievementScalarizationComparator(i));
            extremePoints[i] = new double[extreme.getNumberOfObjectives()];
            for (int j = 0; j < extremePoints.length; ++j) {
                extremePoints[i][j] = extreme.getObjective(j);
            }
        }
        return extremePoints;
    }

    public static <S extends Solution<?>> void sumOfObjectives(List<S> solutionsList) {
        for (Solution solution : solutionsList) {
            double sum = solution.getObjective(0);
            for (int i = 1; i < solution.getNumberOfObjectives(); ++i) {
                sum += solution.getObjective(i);
            }
            ScalarizationUtils.setScalarizationValue(solution, sum);
        }
    }

    public static <S extends Solution<?>> void weightedSum(List<S> solutionsList, double[] weights) {
        for (Solution solution : solutionsList) {
            double sum = weights[0] * solution.getObjective(0);
            for (int i = 1; i < solution.getNumberOfObjectives(); ++i) {
                sum += weights[i] * solution.getObjective(i);
            }
            ScalarizationUtils.setScalarizationValue(solution, sum);
        }
    }

    public static <S extends Solution<?>> void productOfObjectives(List<S> solutionsList) {
        for (Solution solution : solutionsList) {
            double product = solution.getObjective(0);
            for (int i = 1; i < solution.getNumberOfObjectives(); ++i) {
                product *= solution.getObjective(i);
            }
            ScalarizationUtils.setScalarizationValue(solution, product);
        }
    }

    public static <S extends Solution<?>> void weightedProduct(List<S> solutionsList, double[] weights) {
        for (Solution solution : solutionsList) {
            double product = Math.pow(solution.getObjective(0), weights[0]);
            for (int i = 1; i < solution.getNumberOfObjectives(); ++i) {
                product *= Math.pow(solution.getObjective(i), weights[i]);
            }
            ScalarizationUtils.setScalarizationValue(solution, product);
        }
    }

    public static <S extends Solution<?>> void chebyshev(List<S> solutionsList) {
        ScalarizationUtils.chebyshev(solutionsList, ScalarizationUtils.getIdealValues(solutionsList));
    }

    public static <S extends Solution<?>> void weightedChebyshev(List<S> solutionsList, double[] weights) {
        ScalarizationUtils.weightedChebyshev(solutionsList, ScalarizationUtils.getIdealValues(solutionsList), weights);
    }

    public static <S extends Solution<?>> void chebyshev(List<S> solutionsList, double[] idealValues) {
        for (Solution solution : solutionsList) {
            double max = solution.getObjective(0) - idealValues[0];
            for (int i = 1; i < solution.getNumberOfObjectives(); ++i) {
                max = Math.max(max, solution.getObjective(i) - idealValues[i]);
            }
            ScalarizationUtils.setScalarizationValue(solution, max);
        }
    }

    public static <S extends Solution<?>> void weightedChebyshev(List<S> solutionsList, double[] idealValues, double[] weights) {
        for (Solution solution : solutionsList) {
            double max = weights[0] * (solution.getObjective(0) - idealValues[0]);
            for (int i = 1; i < solution.getNumberOfObjectives(); ++i) {
                max = Math.max(max, weights[i] * (solution.getObjective(i) - idealValues[i]));
            }
            ScalarizationUtils.setScalarizationValue(solution, max);
        }
    }

    public static <S extends Solution<?>> void nash(List<S> solutionsList) {
        ScalarizationUtils.nash(solutionsList, ScalarizationUtils.getNadirValues(solutionsList));
    }

    public static <S extends Solution<?>> void nash(List<S> solutionsList, double[] nadirValues) {
        for (Solution solution : solutionsList) {
            double nash = nadirValues[0] - solution.getObjective(0);
            for (int i = 1; i < nadirValues.length; ++i) {
                nash *= nadirValues[i] - solution.getObjective(i);
            }
            ScalarizationUtils.setScalarizationValue(solution, -nash);
        }
    }

    public static <S extends Solution<?>> void angleUtility(List<S> solutionsList) {
        ScalarizationUtils.angleUtility(solutionsList, ScalarizationUtils.getExtremePoints(solutionsList));
    }

    public static <S extends Solution<?>> void angleUtility(List<S> solutionsList, double[][] extremePoints) {
        for (Solution solution : solutionsList) {
            double fraction = 0.0;
            for (int i = 0; i < extremePoints.length; ++i) {
                double numerator = 0.0;
                double denominator = 0.0;
                for (int j = 0; j < extremePoints.length; ++j) {
                    if (i == j) {
                        denominator = Math.abs(extremePoints[i][j] - solution.getObjective(j));
                        continue;
                    }
                    numerator += Math.pow(extremePoints[i][j] - solution.getObjective(j), 2.0);
                }
                fraction = denominator > 1.0E-5 ? Math.max(fraction, Math.sqrt(numerator) / denominator) : Double.MAX_VALUE;
            }
            ScalarizationUtils.setScalarizationValue(solution, Math.atan(fraction));
        }
    }

    public static <S extends Solution<?>> void tradeoffUtility(List<S> solutionsList) {
        for (Solution solution : solutionsList) {
            ScalarizationUtils.setScalarizationValue(solution, 0.0);
        }
        for (int cur = 0; cur < solutionsList.size() - 1; ++cur) {
            Solution current = (Solution)solutionsList.get(cur);
            for (int oth = cur + 1; oth < solutionsList.size(); ++oth) {
                Solution other = (Solution)solutionsList.get(oth);
                double numerator = 0.0;
                double denominator = 0.0;
                for (int i = 0; i < current.getNumberOfObjectives(); ++i) {
                    if (current.getObjective(i) > other.getObjective(i)) {
                        numerator = Math.max(numerator, current.getObjective(i) - other.getObjective(i));
                        continue;
                    }
                    if (!(current.getObjective(i) < other.getObjective(i))) continue;
                    denominator = Math.max(denominator, other.getObjective(i) - current.getObjective(i));
                }
                if (numerator == 0.0 || denominator == 0.0) continue;
                ScalarizationUtils.setScalarizationValue(current, Math.max(ScalarizationUtils.getScalarizationValue(current), numerator / denominator));
                ScalarizationUtils.setScalarizationValue(other, Math.max(ScalarizationUtils.getScalarizationValue(other), denominator / numerator));
            }
        }
    }

    public static <S extends Solution<?>> void uniform(List<S> solutionsList) {
        for (Solution solution : solutionsList) {
            ScalarizationUtils.setScalarizationValue(solution, 1.0);
        }
    }
}

