/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.gwasfga;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.gwasfga.util.GWASFGARanking;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.ASFWASFGA;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.AbstractUtilityFunctionsSet;
import org.uma.jmetal.algorithm.multiobjective.wasfga.WASFGA;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.Ranking;

public class GWASFGA<S extends Solution<?>>
extends WASFGA<S> {
    private final AbstractUtilityFunctionsSet<S> achievementScalarizingUtopia;
    private final AbstractUtilityFunctionsSet<S> achievementScalarizingNadir;
    private static final long serialVersionUID = 1L;

    public GWASFGA(Problem<S> problem, int populationSize, int maxIterations, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator, double epsilon, String weightVectorsFileName) {
        super(problem, populationSize, maxIterations, crossoverOperator, mutationOperator, selectionOperator, evaluator, epsilon, null, weightVectorsFileName);
        int i;
        this.setMaxPopulationSize(populationSize);
        int halfVectorSize = this.weights.length / 2;
        int evenVectorsSize = this.weights.length % 2 == 0 ? halfVectorSize : halfVectorSize + 1;
        double[][] evenVectors = new double[evenVectorsSize][this.getProblem().getNumberOfObjectives()];
        double[][] oddVectors = new double[halfVectorSize][this.getProblem().getNumberOfObjectives()];
        int index = 0;
        for (i = 0; i < this.weights.length; i += 2) {
            evenVectors[index++] = this.weights[i];
        }
        index = 0;
        for (i = 1; i < this.weights.length; i += 2) {
            oddVectors[index++] = this.weights[i];
        }
        this.achievementScalarizingNadir = this.createUtilityFunction(this.getNadirPoint(), evenVectors);
        this.achievementScalarizingUtopia = this.createUtilityFunction(this.getReferencePoint(), oddVectors);
    }

    public GWASFGA(Problem<S> problem, int populationSize, int maxIterations, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator, double epsilon) {
        this(problem, populationSize, maxIterations, crossoverOperator, mutationOperator, selectionOperator, evaluator, epsilon, "");
    }

    private AbstractUtilityFunctionsSet<S> createUtilityFunction(List<Double> referencePoint, double[][] weights) {
        return new ASFWASFGA(weights, referencePoint);
    }

    @Override
    protected Ranking<S> computeRanking(List<S> solutionList) {
        GWASFGARanking<S> ranking = new GWASFGARanking<S>(this.achievementScalarizingUtopia, this.achievementScalarizingNadir);
        ranking.computeRanking(solutionList);
        return ranking;
    }

    @Override
    public String getName() {
        return "GWASFGA";
    }

    @Override
    public String getDescription() {
        return "Global Weighting Achievement Scalarizing Function Genetic Algorithm";
    }
}

