/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mochc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractEvolutionaryAlgorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class MOCHC
extends AbstractEvolutionaryAlgorithm<BinarySolution, List<BinarySolution>> {
    private BinaryProblem problem;
    private int maxEvaluations;
    private int maxPopulationSize;
    private int convergenceValue;
    private double preservedPopulation;
    private double initialConvergenceCount;
    private CrossoverOperator<BinarySolution> crossover;
    private MutationOperator<BinarySolution> cataclysmicMutation;
    private SelectionOperator<List<BinarySolution>, List<BinarySolution>> newGenerationSelection;
    private SelectionOperator<List<BinarySolution>, BinarySolution> parentSelection;
    private int evaluations;
    private int minimumDistance;
    private int size;
    private Comparator<BinarySolution> comparator;
    private SolutionListEvaluator<BinarySolution> evaluator;
    private int lastOffspringPopulationSize;

    public MOCHC(BinaryProblem problem, int populationSize, int maxEvaluations, int convergenceValue, double preservedPopulation, double initialConvergenceCount, CrossoverOperator<BinarySolution> crossoverOperator, MutationOperator<BinarySolution> cataclysmicMutation, SelectionOperator<List<BinarySolution>, List<BinarySolution>> newGenerationSelection, SelectionOperator<List<BinarySolution>, BinarySolution> parentSelection, SolutionListEvaluator<BinarySolution> evaluator) {
        this.problem = problem;
        this.setMaxPopulationSize(populationSize);
        this.maxEvaluations = maxEvaluations;
        this.convergenceValue = convergenceValue;
        this.preservedPopulation = preservedPopulation;
        this.initialConvergenceCount = initialConvergenceCount;
        this.crossover = crossoverOperator;
        this.cataclysmicMutation = cataclysmicMutation;
        this.newGenerationSelection = newGenerationSelection;
        this.parentSelection = parentSelection;
        this.evaluator = evaluator;
        for (int i = 0; i < problem.getNumberOfVariables(); ++i) {
            this.size += problem.getNumberOfBits(i);
        }
        this.minimumDistance = (int)Math.floor(this.initialConvergenceCount * (double)this.size);
        this.comparator = new CrowdingDistanceComparator<BinarySolution>();
    }

    public void setMaxPopulationSize(int maxPopulationSize) {
        this.maxPopulationSize = maxPopulationSize;
    }

    public int getMaxPopulationSize() {
        return this.maxPopulationSize;
    }

    @Override
    protected void initProgress() {
        this.evaluations = this.getMaxPopulationSize();
    }

    @Override
    protected void updateProgress() {
        this.evaluations += this.lastOffspringPopulationSize;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    @Override
    protected List<BinarySolution> createInitialPopulation() {
        ArrayList<BinarySolution> population = new ArrayList<BinarySolution>(this.getMaxPopulationSize());
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            BinarySolution newIndividual = (BinarySolution)this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    @Override
    protected List<BinarySolution> evaluatePopulation(List<BinarySolution> population) {
        population = this.evaluator.evaluate(population, this.problem);
        return population;
    }

    @Override
    protected List<BinarySolution> selection(List<BinarySolution> population) {
        ArrayList<BinarySolution> matingPopulation = new ArrayList<BinarySolution>(population.size());
        for (int i = 0; i < population.size(); ++i) {
            BinarySolution solution = (BinarySolution)this.parentSelection.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    @Override
    protected List<BinarySolution> reproduction(List<BinarySolution> matingPopulation) {
        ArrayList<BinarySolution> offspringPopulation = new ArrayList<BinarySolution>();
        for (int i = 0; i < matingPopulation.size(); i += 2) {
            ArrayList<BinarySolution> parents = new ArrayList<BinarySolution>(2);
            parents.add(matingPopulation.get(i));
            parents.add(matingPopulation.get(i + 1));
            if (this.hammingDistance((BinarySolution)parents.get(0), (BinarySolution)parents.get(1)) < this.minimumDistance) continue;
            List offspring = (List)this.crossover.execute((BinarySolution)((Object)parents));
            offspringPopulation.add((BinarySolution)offspring.get(0));
            offspringPopulation.add((BinarySolution)offspring.get(1));
        }
        this.lastOffspringPopulationSize = offspringPopulation.size();
        return offspringPopulation;
    }

    @Override
    protected List<BinarySolution> replacement(List<BinarySolution> population, List<BinarySolution> offspringPopulation) {
        ArrayList<BinarySolution> union = new ArrayList<BinarySolution>();
        union.addAll(population);
        union.addAll(offspringPopulation);
        ArrayList<BinarySolution> newPopulation = (ArrayList<BinarySolution>)this.newGenerationSelection.execute(union);
        if (SolutionListUtils.solutionListsAreEquals(population, newPopulation)) {
            --this.minimumDistance;
        }
        if (this.minimumDistance <= -this.convergenceValue) {
            int i;
            this.minimumDistance = (int)(0.22749999999999998 * (double)this.size);
            int preserve = (int)Math.floor(this.preservedPopulation * (double)population.size());
            newPopulation = new ArrayList<BinarySolution>(this.getMaxPopulationSize());
            Collections.sort(population, this.comparator);
            for (i = 0; i < preserve; ++i) {
                newPopulation.add((BinarySolution)population.get(i).copy());
            }
            for (i = preserve; i < this.getMaxPopulationSize(); ++i) {
                BinarySolution solution = (BinarySolution)population.get(i).copy();
                this.cataclysmicMutation.execute(solution);
                newPopulation.add(solution);
            }
        }
        return newPopulation;
    }

    @Override
    public List<BinarySolution> getResult() {
        NonDominatedSolutionListArchive<BinarySolution> archive = new NonDominatedSolutionListArchive<BinarySolution>();
        for (BinarySolution solution : this.getPopulation()) {
            archive.add(solution);
        }
        return archive.getSolutionList();
    }

    private int hammingDistance(BinarySolution solutionOne, BinarySolution solutionTwo) {
        int distance = 0;
        for (int i = 0; i < this.problem.getNumberOfVariables(); ++i) {
            distance += this.hammingDistance((BinarySet)solutionOne.getVariableValue(i), (BinarySet)solutionTwo.getVariableValue(i));
        }
        return distance;
    }

    private int hammingDistance(BinarySet bitSet1, BinarySet bitSet2) {
        if (bitSet1.getBinarySetLength() != bitSet2.getBinarySetLength()) {
            throw new JMetalException("The bitsets have different length: " + bitSet1.getBinarySetLength() + ", " + bitSet2.getBinarySetLength());
        }
        int distance = 0;
        for (int i = 0; i < bitSet1.getBinarySetLength(); ++i) {
            if (bitSet1.get(i) == bitSet2.get(i)) continue;
            ++distance;
        }
        return distance;
    }

    @Override
    public String getName() {
        return "MOCHC";
    }

    @Override
    public String getDescription() {
        return "Multiobjective CHC algorithm";
    }
}

