/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mochc;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.mochc.MOCHC;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.AlgorithmBuilder;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class MOCHCBuilder
implements AlgorithmBuilder<MOCHC> {
    BinaryProblem problem;
    SolutionListEvaluator<BinarySolution> evaluator;
    int populationSize;
    int maxEvaluations;
    int convergenceValue;
    double preservedPopulation;
    double initialConvergenceCount;
    CrossoverOperator<BinarySolution> crossoverOperator;
    MutationOperator<BinarySolution> cataclysmicMutation;
    SelectionOperator<List<BinarySolution>, BinarySolution> parentSelection;
    SelectionOperator<List<BinarySolution>, List<BinarySolution>> newGenerationSelection;

    public MOCHCBuilder(BinaryProblem problem) {
        this.problem = problem;
        this.evaluator = new SequentialSolutionListEvaluator<BinarySolution>();
        this.populationSize = 100;
        this.maxEvaluations = 25000;
        this.convergenceValue = 3;
        this.preservedPopulation = 0.05;
        this.initialConvergenceCount = 0.25;
    }

    public BinaryProblem getProblem() {
        return this.problem;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getMaxEvaluation() {
        return this.maxEvaluations;
    }

    public double getInitialConvergenceCount() {
        return this.initialConvergenceCount;
    }

    public int getConvergenceValue() {
        return this.convergenceValue;
    }

    public CrossoverOperator<BinarySolution> getCrossover() {
        return this.crossoverOperator;
    }

    public MutationOperator<BinarySolution> getCataclysmicMutation() {
        return this.cataclysmicMutation;
    }

    public SelectionOperator<List<BinarySolution>, BinarySolution> getParentSelection() {
        return this.parentSelection;
    }

    public SelectionOperator<List<BinarySolution>, List<BinarySolution>> getNewGenerationSelection() {
        return this.newGenerationSelection;
    }

    public double getPreservedPopulation() {
        return this.preservedPopulation;
    }

    public MOCHCBuilder setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
        return this;
    }

    public MOCHCBuilder setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
        return this;
    }

    public MOCHCBuilder setConvergenceValue(int convergenceValue) {
        this.convergenceValue = convergenceValue;
        return this;
    }

    public MOCHCBuilder setInitialConvergenceCount(double initialConvergenceCount) {
        this.initialConvergenceCount = initialConvergenceCount;
        return this;
    }

    public MOCHCBuilder setPreservedPopulation(double preservedPopulation) {
        this.preservedPopulation = preservedPopulation;
        return this;
    }

    public MOCHCBuilder setCrossover(CrossoverOperator<BinarySolution> crossover) {
        this.crossoverOperator = crossover;
        return this;
    }

    public MOCHCBuilder setCataclysmicMutation(MutationOperator<BinarySolution> cataclysmicMutation) {
        this.cataclysmicMutation = cataclysmicMutation;
        return this;
    }

    public MOCHCBuilder setParentSelection(SelectionOperator<List<BinarySolution>, BinarySolution> parentSelection) {
        this.parentSelection = parentSelection;
        return this;
    }

    public MOCHCBuilder setNewGenerationSelection(SelectionOperator<List<BinarySolution>, List<BinarySolution>> newGenerationSelection) {
        this.newGenerationSelection = newGenerationSelection;
        return this;
    }

    public MOCHCBuilder setEvaluator(SolutionListEvaluator<BinarySolution> evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    @Override
    public MOCHC build() {
        MOCHC algorithm = new MOCHC(this.problem, this.populationSize, this.maxEvaluations, this.convergenceValue, this.preservedPopulation, this.initialConvergenceCount, this.crossoverOperator, this.cataclysmicMutation, this.newGenerationSelection, this.parentSelection, this.evaluator);
        return algorithm;
    }
}

