/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.moead;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.util.MOEADUtils;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class MOEADDRA
extends AbstractMOEAD<DoubleSolution> {
    protected DifferentialEvolutionCrossover differentialEvolutionCrossover;
    protected DoubleSolution[] savedValues;
    protected double[] utility;
    protected int[] frequency;
    JMetalRandom randomGenerator;

    public MOEADDRA(Problem<DoubleSolution> problem, int populationSize, int resultPopulationSize, int maxEvaluations, MutationOperator<DoubleSolution> mutation, CrossoverOperator<DoubleSolution> crossover, AbstractMOEAD.FunctionType functionType, String dataDirectory, double neighborhoodSelectionProbability, int maximumNumberOfReplacedSolutions, int neighborSize) {
        super(problem, populationSize, resultPopulationSize, maxEvaluations, crossover, mutation, functionType, dataDirectory, neighborhoodSelectionProbability, maximumNumberOfReplacedSolutions, neighborSize);
        this.differentialEvolutionCrossover = (DifferentialEvolutionCrossover)this.crossoverOperator;
        this.savedValues = new DoubleSolution[populationSize];
        this.utility = new double[populationSize];
        this.frequency = new int[populationSize];
        for (int i = 0; i < this.utility.length; ++i) {
            this.utility[i] = 1.0;
            this.frequency[i] = 0;
        }
        this.randomGenerator = JMetalRandom.getInstance();
    }

    @Override
    public void run() {
        this.initializePopulation();
        this.initializeUniformWeight();
        this.initializeNeighborhood();
        this.initializeIdealPoint();
        int generation = 0;
        this.evaluations = this.populationSize;
        do {
            int[] permutation = new int[this.populationSize];
            MOEADUtils.randomPermutation(permutation, this.populationSize);
            for (int i = 0; i < this.populationSize; ++i) {
                int subProblemId;
                int n = subProblemId = permutation[i];
                this.frequency[n] = this.frequency[n] + 1;
                AbstractMOEAD.NeighborType neighborType = this.chooseNeighborType();
                List<DoubleSolution> parents = this.parentSelection(subProblemId, neighborType);
                this.differentialEvolutionCrossover.setCurrentSolution((DoubleSolution)this.population.get(subProblemId));
                List<DoubleSolution> children = this.differentialEvolutionCrossover.execute(parents);
                DoubleSolution child = children.get(0);
                this.mutationOperator.execute(child);
                this.problem.evaluate(child);
                ++this.evaluations;
                this.updateIdealPoint(child);
                this.updateNeighborhood(child, subProblemId, neighborType);
            }
            if (++generation % 30 != 0) continue;
            this.utilityFunction();
        } while (this.evaluations < this.maxEvaluations);
    }

    protected void initializePopulation() {
        for (int i = 0; i < this.populationSize; ++i) {
            DoubleSolution newSolution = (DoubleSolution)this.problem.createSolution();
            this.problem.evaluate(newSolution);
            this.population.add(newSolution);
            this.savedValues[i] = (DoubleSolution)newSolution.copy();
        }
    }

    public void utilityFunction() throws JMetalException {
        for (int n = 0; n < this.populationSize; ++n) {
            double uti;
            double f1 = this.fitnessFunction((Solution)this.population.get(n), this.lambda[n]);
            double f2 = this.fitnessFunction(this.savedValues[n], this.lambda[n]);
            double delta = f2 - f1;
            this.utility[n] = delta > 0.001 ? 1.0 : ((uti = (0.95 + 0.05 * delta / 0.001) * this.utility[n]) < 1.0 ? uti : 1.0);
            this.savedValues[n] = (DoubleSolution)((DoubleSolution)this.population.get(n)).copy();
        }
    }

    public List<Integer> tourSelection(int depth) {
        ArrayList<Integer> selected = new ArrayList<Integer>();
        ArrayList<Integer> candidate = new ArrayList<Integer>();
        for (int k = 0; k < this.problem.getNumberOfObjectives(); ++k) {
            selected.add(k);
        }
        for (int n = this.problem.getNumberOfObjectives(); n < this.populationSize; ++n) {
            candidate.add(n);
        }
        while (selected.size() < (int)((double)this.populationSize / 5.0)) {
            int best_idd = (int)(this.randomGenerator.nextDouble() * (double)candidate.size());
            int best_sub = (Integer)candidate.get(best_idd);
            for (int i = 1; i < depth; ++i) {
                int i2 = (int)(this.randomGenerator.nextDouble() * (double)candidate.size());
                int s2 = (Integer)candidate.get(i2);
                if (!(this.utility[s2] > this.utility[best_sub])) continue;
                best_idd = i2;
                best_sub = s2;
            }
            selected.add(best_sub);
            candidate.remove(best_idd);
        }
        return selected;
    }

    @Override
    public String getName() {
        return "MOEADDRA";
    }

    @Override
    public String getDescription() {
        return "Multi-Objective Evolutionary Algorithm based on Decomposition. Version with Dynamic Resource Allocation";
    }
}

