/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mombi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.mombi.MOMBI;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.ASFUtilityFunctionSet;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.AbstractUtilityFunctionsSet;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.MOMBI2History;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.Normalizer;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.R2Ranking;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.R2RankingNormalized;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class MOMBI2<S extends Solution<?>>
extends MOMBI<S> {
    protected final MOMBI2History<S> history;
    protected final Double alpha = 0.5;
    protected final Double epsilon = 0.001;
    protected List<Double> maxs;
    protected Normalizer normalizer;

    public MOMBI2(Problem<S> problem, int maxIterations, CrossoverOperator<S> crossover, MutationOperator<S> mutation, SelectionOperator<List<S>, S> selection, SolutionListEvaluator<S> evaluator, String pathWeights) {
        super(problem, maxIterations, crossover, mutation, selection, evaluator, pathWeights);
        this.history = new MOMBI2History(problem.getNumberOfObjectives());
    }

    protected void updateMax(List<S> population) {
        for (Solution solution : population) {
            for (int i = 0; i < this.maxs.size(); ++i) {
                this.maxs.set(i, Math.max(this.maxs.get(i), solution.getObjective(i)));
            }
        }
        this.history.add(this.maxs);
    }

    @Override
    protected void initProgress() {
        super.initProgress();
        this.updateMax(this.getPopulation());
    }

    @Override
    public AbstractUtilityFunctionsSet<S> createUtilityFunction(String pathWeights) {
        System.out.println("MOMBI 2");
        this.maxs = new ArrayList<Double>(Collections.nCopies(this.getProblem().getNumberOfObjectives(), Double.NEGATIVE_INFINITY));
        this.normalizer = new Normalizer(this.getReferencePoint(), this.maxs);
        ASFUtilityFunctionSet aux = new ASFUtilityFunctionSet(pathWeights);
        aux.setNormalizer(this.normalizer);
        return aux;
    }

    @Override
    public void updateReferencePoint(List<S> population) {
        ArrayList<Double> iterationMaxs = new ArrayList<Double>(this.maxs.size());
        for (int i = 0; i < this.getProblem().getNumberOfObjectives(); ++i) {
            iterationMaxs.add(Double.NEGATIVE_INFINITY);
        }
        for (Solution solution : population) {
            this.updateReferencePoint(solution);
            for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
                iterationMaxs.set(i, Math.max((Double)iterationMaxs.get(i), solution.getObjective(i)));
            }
        }
        this.history.add(iterationMaxs);
        List<Double> mean = this.history.mean();
        List<Double> var = this.history.variance(mean);
        Double maxVariance = this.getMax(var);
        if (maxVariance > this.alpha) {
            Double maxInNadir = this.getMax(this.maxs);
            for (int i = 0; i < this.getProblem().getNumberOfObjectives(); ++i) {
                this.maxs.set(i, maxInNadir);
            }
        } else {
            for (int i = 0; i < this.getProblem().getNumberOfObjectives(); ++i) {
                if (Math.abs(this.maxs.get(i) - this.getReferencePoint().get(i)) < this.epsilon) {
                    Double maxInMaxs = this.getMax(this.maxs);
                    this.maxs.set(i, maxInMaxs);
                    this.history.mark(i);
                } else if ((Double)iterationMaxs.get(i) > this.maxs.get(i)) {
                    this.maxs.set(i, (Double)iterationMaxs.get(i) + Math.abs((Double)iterationMaxs.get(i) - this.maxs.get(i)));
                    this.history.mark(i);
                } else if (var.get(i) == 0.0 && this.history.isUnMarked(i)) {
                    double v = this.history.getMaxObjective(i);
                    this.maxs.set(i, (this.maxs.get(i) + v) / 2.0);
                    this.history.mark(i);
                }
                this.history.decreaseMark(i);
            }
        }
    }

    @Override
    protected R2Ranking<S> computeRanking(List<S> solutionList) {
        R2RankingNormalized<S> ranking = new R2RankingNormalized<S>(this.getUtilityFunctions(), this.normalizer);
        ((R2Ranking)ranking).computeRanking(solutionList);
        return ranking;
    }

    public Double getMax(List<Double> list) {
        Double result = Double.NEGATIVE_INFINITY;
        for (Double d : list) {
            result = Math.max(result, d);
        }
        return result;
    }

    @Override
    public String getName() {
        return "MOMBI";
    }

    @Override
    public String getDescription() {
        return "Many-Objective Metaheuristic Based on the R2 Indicator, version 2";
    }
}

