/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mombi.util;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.AbstractUtilityFunctionsSet;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.Normalizer;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;

public class ASFUtilityFunctionSet<S extends Solution<?>>
extends AbstractUtilityFunctionsSet<S> {
    private final List<Double> referencePoint;
    private Normalizer normalizer = null;

    public ASFUtilityFunctionSet(double[][] weights, List<Double> referencePoint) {
        super(weights);
        this.referencePoint = referencePoint;
    }

    public ASFUtilityFunctionSet(double[][] weights) {
        super(weights);
        this.referencePoint = new ArrayList<Double>(this.getVectorSize());
        for (int i = 0; i < this.getVectorSize(); ++i) {
            this.referencePoint.add(0.0);
        }
    }

    public ASFUtilityFunctionSet(String file_path, List<Double> referencePoint) {
        super(file_path);
        this.referencePoint = referencePoint;
    }

    public ASFUtilityFunctionSet(String file_path) {
        super(file_path);
        this.referencePoint = new ArrayList<Double>(this.getVectorSize());
        for (int i = 0; i < this.getVectorSize(); ++i) {
            this.referencePoint.add(0.0);
        }
    }

    @Override
    public Double evaluate(S solution, int vector) {
        int i;
        if (vector < 0 || vector >= this.getSize()) {
            throw new JMetalException("Vector value " + vector + " invalid");
        }
        double result = Double.NEGATIVE_INFINITY;
        List<Double> weightVector = this.getWeightVector(vector);
        ArrayList<Double> objectiveValues = new ArrayList<Double>(solution.getNumberOfObjectives());
        for (i = 0; i < solution.getNumberOfObjectives(); ++i) {
            if (this.normalizer == null) {
                objectiveValues.add(solution.getObjective(i));
                continue;
            }
            objectiveValues.add(this.normalizer.normalize(solution.getObjective(i), i));
        }
        for (i = 0; i < weightVector.size(); ++i) {
            result = Math.max(result, Math.abs((Double)objectiveValues.get(i) - this.referencePoint.get(i)) / (weightVector.get(i) > 0.0 ? weightVector.get(i) : 0.01));
        }
        return result;
    }

    public void setNormalizer(Normalizer normalizer) {
        this.normalizer = normalizer;
    }
}

