/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaii;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class SteadyStateNSGAII<S extends Solution<?>>
extends NSGAII<S> {
    public SteadyStateNSGAII(Problem<S> problem, int maxEvaluations, int populationSize, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, Comparator<S> dominanceComparator, SolutionListEvaluator<S> evaluator) {
        super(problem, maxEvaluations, populationSize, crossoverOperator, mutationOperator, selectionOperator, dominanceComparator, evaluator);
    }

    @Override
    protected void updateProgress() {
        ++this.evaluations;
    }

    @Override
    protected List<S> selection(List<S> population) {
        ArrayList matingPopulation = new ArrayList(2);
        matingPopulation.add(this.selectionOperator.execute(population));
        matingPopulation.add(this.selectionOperator.execute(population));
        return matingPopulation;
    }

    @Override
    protected List<S> reproduction(List<S> population) {
        ArrayList offspringPopulation = new ArrayList(1);
        ArrayList<S> parents = new ArrayList<S>(2);
        parents.add(population.get(0));
        parents.add(population.get(1));
        List offspring = (List)this.crossoverOperator.execute(parents);
        this.mutationOperator.execute(offspring.get(0));
        offspringPopulation.add(offspring.get(0));
        return offspringPopulation;
    }

    @Override
    public String getName() {
        return "ssNSGAII";
    }

    @Override
    public String getDescription() {
        return "Nondominated Sorting Genetic Algorithm version II. Steady-state version";
    }
}

