/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.singleobjective.evolutionstrategy.util;

import org.uma.jmetal.util.JMetalLogger;

public class CMAESUtils {
    private CMAESUtils() {
    }

    public static void tred2(int n, double[][] v, double[] d, double[] e) {
        System.arraycopy(v[n - 1], 0, d, 0, n);
        for (int i = n - 1; i > 0; --i) {
            double scale = 0.0;
            double h = 0.0;
            for (int k = 0; k < i; ++k) {
                scale += Math.abs(d[k]);
            }
            if (scale == 0.0) {
                e[i] = d[i - 1];
                for (int j = 0; j < i; ++j) {
                    d[j] = v[i - 1][j];
                    v[i][j] = 0.0;
                    v[j][i] = 0.0;
                }
            } else {
                h = CMAESUtils.householderIteration(i, scale, v, d, e);
            }
            d[i] = h;
        }
        CMAESUtils.accumulateTransformations(n, v, d);
        e[0] = 0.0;
    }

    private static double householderIteration(int index, double scale, double[][] v, double[] d, double[] e) {
        int j;
        int j2;
        double h = 0.0;
        for (int k = 0; k < index; ++k) {
            int n = k;
            d[n] = d[n] / scale;
            h += d[k] * d[k];
        }
        double f = d[index - 1];
        double g = Math.sqrt(h);
        if (f > 0.0) {
            g = -g;
        }
        e[index] = scale * g;
        h -= f * g;
        d[index - 1] = f - g;
        for (j2 = 0; j2 < index; ++j2) {
            e[j2] = 0.0;
        }
        for (j2 = 0; j2 < index; ++j2) {
            v[j2][index] = f = d[j2];
            g = e[j2] + v[j2][j2] * f;
            for (int k = j2 + 1; k <= index - 1; ++k) {
                g += v[k][j2] * d[k];
                int n = k;
                e[n] = e[n] + v[k][j2] * f;
            }
            e[j2] = g;
        }
        f = 0.0;
        for (j2 = 0; j2 < index; ++j2) {
            int n = j2;
            e[n] = e[n] / h;
            f += e[j2] * d[j2];
        }
        double hh = f / (h + h);
        for (j = 0; j < index; ++j) {
            int n = j;
            e[n] = e[n] - hh * d[j];
        }
        for (j = 0; j < index; ++j) {
            f = d[j];
            g = e[j];
            for (int k = j; k <= index - 1; ++k) {
                double[] dArray = v[k];
                int n = j;
                dArray[n] = dArray[n] - (f * e[k] + g * d[k]);
            }
            d[j] = v[index - 1][j];
            v[index][j] = 0.0;
        }
        return h;
    }

    private static void accumulateTransformations(int n, double[][] v, double[] d) {
        for (int i = 0; i < n - 1; ++i) {
            int k;
            v[n - 1][i] = v[i][i];
            v[i][i] = 1.0;
            double h = d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    d[k] = v[k][i + 1] / h;
                }
                for (int j = 0; j <= i; ++j) {
                    int k2;
                    double g = 0.0;
                    for (k2 = 0; k2 <= i; ++k2) {
                        g += v[k2][i + 1] * v[k2][j];
                    }
                    for (k2 = 0; k2 <= i; ++k2) {
                        double[] dArray = v[k2];
                        int n2 = j;
                        dArray[n2] = dArray[n2] - g * d[k2];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                v[k][i + 1] = 0.0;
            }
        }
        for (int j = 0; j < n; ++j) {
            d[j] = v[n - 1][j];
            v[n - 1][j] = 0.0;
        }
        v[n - 1][n - 1] = 1.0;
    }

    public static void tql2(int n, double[] d, double[] e, double[][] v) {
        System.arraycopy(e, 1, e, 0, n - 1);
        e[n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
            for (m = l; m < n && !(Math.abs(e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    ++iter;
                    f += CMAESUtils.specificShift(l, n, d, e);
                    CMAESUtils.implicitQLTransformation(l, m, n, v, d, e);
                } while (Math.abs(e[l]) > eps * tst1);
            }
            d[l] = d[l] + f;
            e[l] = 0.0;
        }
        CMAESUtils.sortEigenValues(n, d, v);
    }

    private static double specificShift(int idx, int n, double[] d, double[] e) {
        double g = d[idx];
        double p = (d[idx + 1] - g) / (2.0 * e[idx]);
        double r = CMAESUtils.hypot(p, 1.0);
        if (p < 0.0) {
            r = -r;
        }
        d[idx] = e[idx] / (p + r);
        d[idx + 1] = e[idx] * (p + r);
        double h = g - d[idx];
        int i = idx + 2;
        while (i < n) {
            int n2 = i++;
            d[n2] = d[n2] - h;
        }
        return h;
    }

    private static void implicitQLTransformation(int l, int m, int n, double[][] v, double[] d, double[] e) {
        double c;
        double dl1 = d[l + 1];
        double p = d[m];
        double c2 = c = 1.0;
        double c3 = c;
        double el1 = e[l + 1];
        double s = 0.0;
        double s2 = 0.0;
        for (int i = m - 1; i >= l; --i) {
            c3 = c2;
            c2 = c;
            s2 = s;
            double g = c * e[i];
            double h = c * p;
            double r = CMAESUtils.hypot(p, e[i]);
            e[i + 1] = s * r;
            s = e[i] / r;
            c = p / r;
            p = c * d[i] - s * g;
            d[i + 1] = h + s * (c * g + s * d[i]);
            for (int k = 0; k < n; ++k) {
                h = v[k][i + 1];
                v[k][i + 1] = s * v[k][i] + c * h;
                v[k][i] = c * v[k][i] - s * h;
            }
        }
        p = -s * s2 * c3 * el1 * e[l] / dl1;
        e[l] = s * p;
        d[l] = c * p;
    }

    private static void sortEigenValues(int n, double[] d, double[][] v) {
        for (int i = 0; i < n - 1; ++i) {
            int j;
            int k = i;
            double p = d[i];
            for (j = i + 1; j < n; ++j) {
                if (!(d[j] < p)) continue;
                k = j;
                p = d[j];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
            for (j = 0; j < n; ++j) {
                p = v[j][i];
                v[j][i] = v[j][k];
                v[j][k] = p;
            }
        }
    }

    public static int checkEigenSystem(int n, double[][] c, double[] diag, double[][] q) {
        int res = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                String s;
                double cc = 0.0;
                double dd = 0.0;
                for (int k = 0; k < n; ++k) {
                    cc += diag[k] * q[i][k] * q[j][k];
                    dd += q[i][k] * q[j][k];
                }
                if (Math.abs(cc - c[CMAESUtils.biggerValue(i, j)][CMAESUtils.smallerValue(i, j)]) / Math.sqrt(c[i][i] * c[j][j]) > 1.0E-10 && Math.abs(cc - c[CMAESUtils.biggerValue(i, j)][CMAESUtils.smallerValue(i, j)]) > 1.0E-9) {
                    s = " " + i + " " + j + " " + cc + " " + c[CMAESUtils.biggerValue(i, j)][CMAESUtils.smallerValue(i, j)] + " " + (cc - c[CMAESUtils.biggerValue(i, j)][CMAESUtils.smallerValue(i, j)]);
                    JMetalLogger.logger.severe("CMAESUtils.checkEigenSystem: WARNING - imprecise experiment output detected " + s);
                    ++res;
                }
                boolean bl = i == j;
                if (!(Math.abs(dd - (double)bl) > 1.0E-10)) continue;
                s = i + " " + j + " " + dd;
                JMetalLogger.logger.severe("CMAESUtils.checkEigenSystem(): WARNING - imprecise experiment output detected (Q not orthog.) " + s);
                ++res;
            }
        }
        return res;
    }

    public static double norm(double[] vector) {
        double result = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            result += vector[i] * vector[i];
        }
        return result;
    }

    private static double hypot(double a2, double b) {
        double r = 0.0;
        if (Math.abs(a2) > Math.abs(b)) {
            r = b / a2;
            r = Math.abs(a2) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a2 / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        }
        return r;
    }

    private static int biggerValue(int i, int j) {
        return i > j ? i : j;
    }

    private static int smallerValue(int i, int j) {
        return i > j ? j : i;
    }
}

