/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.glt;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class GLT4
extends AbstractDoubleProblem {
    public GLT4() {
        this(10);
    }

    public GLT4(int numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("GLT4");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 1; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-1.0);
            upperLimit.add(1.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        solution.setObjective(0, (1.0 + this.g(solution)) * (Double)solution.getVariableValue(0));
        solution.setObjective(1, (1.0 + this.g(solution)) * (2.0 - 2.0 * Math.pow((Double)solution.getVariableValue(0), 0.5) * Math.pow(Math.cos(2.0 * Math.pow((Double)solution.getVariableValue(0), 0.5) * Math.PI), 2.0)));
    }

    private double g(DoubleSolution solution) {
        double result = 0.0;
        for (int i = 1; i < solution.getNumberOfVariables(); ++i) {
            double value = (Double)solution.getVariableValue(i) - Math.sin(Math.PI * 2 * (Double)solution.getVariableValue(0) + (double)i * Math.PI / (double)solution.getNumberOfVariables());
            result += value * value;
        }
        return result;
    }
}

