/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class MaF13
extends AbstractDoubleProblem {
    public MaF13() {
        this(5, 3);
    }

    public MaF13(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF13");
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(0.0);
            upper.add(1.0);
        }
        this.setLowerLimit(lower);
        this.setUpperLimit(upper);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables_ = solution.getNumberOfVariables();
        int numberOfObjectives_ = solution.getNumberOfObjectives();
        double[] x = new double[numberOfVariables_];
        double[] f = new double[numberOfObjectives_];
        for (int i2 = 0; i2 < numberOfVariables_; ++i2) {
            x[i2] = (Double)solution.getVariableValue(i2);
        }
        double[] y = new double[numberOfVariables_];
        for (int i3 = 0; i3 < numberOfVariables_; ++i3) {
            y[i3] = x[i3] - 2.0 * x[1] * Math.sin(Math.PI * 2 * x[0] + (double)(i3 + 1) * Math.PI / (double)numberOfVariables_);
        }
        ArrayList<Integer> J1 = new ArrayList<Integer>();
        ArrayList<Integer> J2 = new ArrayList<Integer>();
        ArrayList<Integer> J3 = new ArrayList<Integer>();
        ArrayList<Integer> J4 = new ArrayList<Integer>();
        double sub1 = 0.0;
        double sub2 = 0.0;
        double sub3 = 0.0;
        double sub4 = 0.0;
        for (i = 4; i <= numberOfVariables_; i += 3) {
            J1.add(i);
            sub1 += Math.pow(y[i - 1], 2.0);
        }
        sub1 = 2.0 * sub1 / (double)J1.size();
        for (i = 5; i <= numberOfVariables_; i += 3) {
            J2.add(i);
            sub2 += Math.pow(y[i - 1], 2.0);
        }
        sub2 = 2.0 * sub2 / (double)J2.size();
        for (i = 3; i <= numberOfVariables_; i += 3) {
            J3.add(i);
            sub3 += Math.pow(y[i - 1], 2.0);
        }
        sub3 = 2.0 * sub3 / (double)J3.size();
        for (i = 4; i <= numberOfVariables_; ++i) {
            J4.add(i);
            sub4 += Math.pow(y[i - 1], 2.0);
        }
        sub4 = 2.0 * sub4 / (double)J4.size();
        f[0] = Math.sin(Math.PI * x[0] / 2.0) + sub1;
        f[1] = Math.cos(Math.PI * x[0] / 2.0) * Math.sin(Math.PI * x[1] / 2.0) + sub2;
        f[2] = Math.cos(Math.PI * x[0] / 2.0) * Math.cos(Math.PI * x[1] / 2.0) + sub3;
        for (i = 3; i < numberOfObjectives_; ++i) {
            f[i] = Math.pow(f[0], 2.0) + Math.pow(f[1], 10.0) + Math.pow(f[2], 10.0) + sub4;
        }
        for (i = 0; i < numberOfObjectives_; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

