/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl.hypervolume;

import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.Hypervolume;
import org.uma.jmetal.qualityindicator.impl.hypervolume.util.WfgHypervolumeFront;
import org.uma.jmetal.qualityindicator.impl.hypervolume.util.WfgHypervolumeVersion;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.HypervolumeContributionComparator;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.point.impl.ArrayPoint;
import org.uma.jmetal.util.solutionattribute.impl.HypervolumeContributionAttribute;

public class WFGHypervolume<S extends Solution<?>>
extends Hypervolume<S> {
    private Point referencePoint;
    private int numberOfObjectives;
    private static final double DEFAULT_OFFSET = 100.0;
    private double offset = 100.0;

    public WFGHypervolume() {
    }

    public WFGHypervolume(String referenceParetoFrontFile) throws FileNotFoundException {
        super(referenceParetoFrontFile);
        this.numberOfObjectives = this.referenceParetoFront.getPointDimensions();
        this.referencePoint = null;
        this.updateReferencePoint(this.referenceParetoFront);
    }

    public WFGHypervolume(Front referenceParetoFront) {
        super(referenceParetoFront);
        this.numberOfObjectives = referenceParetoFront.getPointDimensions();
        this.referencePoint = null;
        this.updateReferencePoint(referenceParetoFront);
    }

    @Override
    public Double evaluate(List<S> solutionList) {
        double hv;
        if (solutionList.size() == 0) {
            hv = 0.0;
        } else {
            this.numberOfObjectives = ((Solution)solutionList.get(0)).getNumberOfObjectives();
            this.referencePoint = new ArrayPoint(this.numberOfObjectives);
            this.updateReferencePoint(solutionList);
            if (this.numberOfObjectives == 2) {
                Collections.sort(solutionList, new ObjectiveComparator(this.numberOfObjectives - 1, ObjectiveComparator.Ordering.DESCENDING));
                hv = this.get2DHV(solutionList);
            } else {
                this.updateReferencePoint(solutionList);
                WfgHypervolumeVersion wfgHv = new WfgHypervolumeVersion(this.numberOfObjectives, solutionList.size());
                hv = wfgHv.getHV(new WfgHypervolumeFront(solutionList));
            }
        }
        return hv;
    }

    public double computeHypervolume(List<S> solutionList, Point referencePoint) {
        double hv = 0.0;
        if (solutionList.size() == 0) {
            hv = 0.0;
        } else {
            this.numberOfObjectives = ((Solution)solutionList.get(0)).getNumberOfObjectives();
            this.referencePoint = referencePoint;
            if (this.numberOfObjectives == 2) {
                Collections.sort(solutionList, new ObjectiveComparator(1, ObjectiveComparator.Ordering.DESCENDING));
                hv = this.get2DHV(solutionList);
            } else {
                WfgHypervolumeVersion wfgHv = new WfgHypervolumeVersion(this.numberOfObjectives, solutionList.size());
                hv = wfgHv.getHV(new WfgHypervolumeFront(solutionList));
            }
        }
        return hv;
    }

    private void updateReferencePoint(List<? extends Solution<?>> solutionList) {
        int i;
        double[] maxObjectives = new double[this.numberOfObjectives];
        for (i = 0; i < this.numberOfObjectives; ++i) {
            maxObjectives[i] = 0.0;
        }
        for (i = 0; i < solutionList.size(); ++i) {
            for (int j = 0; j < this.numberOfObjectives; ++j) {
                if (!(maxObjectives[j] < solutionList.get(i).getObjective(j))) continue;
                maxObjectives[j] = solutionList.get(i).getObjective(j);
            }
        }
        if (this.referencePoint == null) {
            this.referencePoint = new ArrayPoint(this.numberOfObjectives);
            for (i = 0; i < this.numberOfObjectives; ++i) {
                this.referencePoint.setDimensionValue(i, Double.MAX_VALUE);
            }
        }
        for (i = 0; i < this.referencePoint.getNumberOfDimensions(); ++i) {
            this.referencePoint.setDimensionValue(i, maxObjectives[i] + this.offset);
        }
    }

    private void updateReferencePoint(Front front) {
        int i;
        double[] maxObjectives = new double[this.numberOfObjectives];
        for (i = 0; i < this.numberOfObjectives; ++i) {
            maxObjectives[i] = 0.0;
        }
        for (i = 0; i < front.getNumberOfPoints(); ++i) {
            for (int j = 0; j < this.numberOfObjectives; ++j) {
                if (!(maxObjectives[j] < front.getPoint(i).getDimensionValue(j))) continue;
                maxObjectives[j] = front.getPoint(i).getDimensionValue(j);
            }
        }
        if (this.referencePoint == null) {
            this.referencePoint = new ArrayPoint(this.numberOfObjectives);
            for (i = 0; i < this.numberOfObjectives; ++i) {
                this.referencePoint.setDimensionValue(i, Double.MAX_VALUE);
            }
        }
        for (i = 0; i < this.referencePoint.getNumberOfDimensions(); ++i) {
            this.referencePoint.setDimensionValue(i, maxObjectives[i] + this.offset);
        }
    }

    public double get2DHV(List<? extends Solution<?>> solutionSet) {
        double hv = 0.0;
        if (solutionSet.size() > 0) {
            hv = Math.abs((solutionSet.get(0).getObjective(0) - this.referencePoint.getDimensionValue(0)) * (solutionSet.get(0).getObjective(1) - this.referencePoint.getDimensionValue(1)));
            for (int i = 1; i < solutionSet.size(); ++i) {
                double tmp = Math.abs((solutionSet.get(i).getObjective(0) - this.referencePoint.getDimensionValue(0)) * (solutionSet.get(i).getObjective(1) - solutionSet.get(i - 1).getObjective(1)));
                hv += tmp;
            }
        }
        return hv;
    }

    @Override
    public List<S> computeHypervolumeContribution(List<S> solutionList, List<S> referenceFrontList) {
        this.numberOfObjectives = ((Solution)solutionList.get(0)).getNumberOfObjectives();
        this.updateReferencePoint(referenceFrontList);
        if (solutionList.size() > 1) {
            double[] contributions = new double[solutionList.size()];
            double solutionSetHV = 0.0;
            solutionSetHV = this.evaluate(solutionList);
            for (int i = 0; i < solutionList.size(); ++i) {
                Solution currentPoint = (Solution)solutionList.get(i);
                solutionList.remove(i);
                if (this.numberOfObjectives == 2) {
                    contributions[i] = solutionSetHV - this.get2DHV(solutionList);
                } else {
                    WfgHypervolumeFront front = new WfgHypervolumeFront(solutionList);
                    double hv = new WfgHypervolumeVersion(this.numberOfObjectives, solutionList.size()).getHV(front);
                    contributions[i] = solutionSetHV - hv;
                }
                solutionList.add(i, currentPoint);
            }
            HypervolumeContributionAttribute<Solution> hvContribution = new HypervolumeContributionAttribute<Solution>();
            for (int i = 0; i < solutionList.size(); ++i) {
                hvContribution.setAttribute((Solution)solutionList.get(i), contributions[i]);
            }
            Collections.sort(solutionList, new HypervolumeContributionComparator());
        }
        return solutionList;
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(double offset) {
        this.offset = offset;
    }

    @Override
    public String getDescription() {
        return "WFG implementation of the hypervolume quality indicator";
    }
}

