/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.singleobjective;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.singleobjective.coralreefsoptimization.CoralReefsOptimizationBuilder;
import org.uma.jmetal.operator.impl.crossover.SinglePointCrossover;
import org.uma.jmetal.operator.impl.mutation.BitFlipMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.singleobjective.OneMax;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class CoralReefsOptimizationRunner {
    public static void main(String[] args) throws Exception {
        OneMax problem = new OneMax(512);
        SinglePointCrossover crossoverOperator = new SinglePointCrossover(0.9);
        BitFlipMutation mutationOperator = new BitFlipMutation(1.0 / (double)problem.getNumberOfBits(0));
        BinaryTournamentSelection selectionOperator = new BinaryTournamentSelection();
        Algorithm algorithm = new CoralReefsOptimizationBuilder<BinarySolution>(problem, selectionOperator, crossoverOperator, mutationOperator).setM(10).setN(10).setRho(0.6).setFbs(0.9).setFbr(0.1).setFa(0.1).setPd(0.1).setAttemptsToSettle(3).setComparator(new ObjectiveComparator(0)).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionListOutput(population).setSeparator("\t").setVarFileOutputContext(new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext(new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }
}

