/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Future;
import weka.classifiers.AbstractClassifier;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.OptionMetadata;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.gui.boundaryvisualizer.DataGenerator;
import weka.gui.boundaryvisualizer.KDDataGenerator;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.ExecutionResult;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.StepTask;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.Classifier;
import weka.knowledgeflow.steps.Clusterer;
import weka.knowledgeflow.steps.DataCollector;
import weka.knowledgeflow.steps.ImageViewer;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.Step;

@KFStep(name="BoundaryPlotter", category="Visualization", toolTipText="Visualize class/cluster decision boundaries in a 2D plot", iconPath="weka/gui/knowledgeflow/icons/DefaultDataVisualizer.gif")
public class BoundaryPlotter
extends BaseStep
implements DataCollector {
    public static final Color[] DEFAULT_COLORS = new Color[]{Color.red, Color.green, Color.blue, new Color(0, 255, 255), new Color(255, 0, 255), new Color(255, 255, 0), new Color(255, 255, 255), new Color(0, 0, 0)};
    private static final long serialVersionUID = 7864251468395026619L;
    protected List<Color> m_Colors = new ArrayList<Color>();
    protected int m_maxRowsInParallel = 10;
    protected int m_imageWidth = 400;
    protected int m_imageHeight = 400;
    protected String m_xAttName = "/first";
    protected String m_yAttName = "2";
    protected boolean m_plotTrainingData = true;
    protected int m_xAttribute;
    protected int m_yAttribute;
    protected double m_minX;
    protected double m_minY;
    protected double m_maxX;
    protected double m_maxY;
    protected double m_rangeX;
    protected double m_rangeY;
    protected double m_pixHeight;
    protected double m_pixWidth;
    protected transient BufferedImage m_osi;
    protected String m_currentDescription;
    protected transient Map<String, BufferedImage> m_completedImages;
    protected List<weka.classifiers.Classifier> m_classifierTemplates;
    protected List<DensityBasedClusterer> m_clustererTemplates;
    protected weka.classifiers.Classifier[] m_threadClassifiers;
    protected weka.clusterers.Clusterer[] m_threadClusterers;
    protected DataGenerator[] m_threadGenerators;
    protected KDDataGenerator m_dataGenerator;
    protected String m_kBand = "3";
    protected String m_nSamples = "2";
    protected String m_sBase = "2";
    protected int m_kernelBandwidth = 3;
    protected int m_numSamplesPerRegion = 2;
    protected int m_samplesBase = 2;
    protected transient RenderingUpdateListener m_plotListener;
    protected boolean m_isReset;

    public BoundaryPlotter() {
        for (Color element : DEFAULT_COLORS) {
            this.m_Colors.add(new Color(element.getRed(), element.getGreen(), element.getBlue()));
        }
    }

    @ProgrammaticProperty
    @OptionMetadata(displayName="X attribute", description="Attribute to visualize on the x-axis", displayOrder=1)
    public void setXAttName(String xAttName) {
        this.m_xAttName = xAttName;
    }

    public String getXAttName() {
        return this.m_xAttName;
    }

    @ProgrammaticProperty
    @OptionMetadata(displayName="Y attribute", description="Attribute to visualize on the y-axis", displayOrder=2)
    public void setYAttName(String attName) {
        this.m_yAttName = attName;
    }

    public String getYAttName() {
        return this.m_yAttName;
    }

    @OptionMetadata(displayName="Base for sampling (r)", description="The base for sampling", displayOrder=3)
    public void setBaseForSampling(String base) {
        this.m_sBase = base;
    }

    public String getBaseForSampling() {
        return this.m_sBase;
    }

    @OptionMetadata(displayName="Num. locations per pixel", description="Number of locations per pixel", displayOrder=4)
    public void setNumLocationsPerPixel(String num) {
        this.m_nSamples = num;
    }

    public String getNumLocationsPerPixel() {
        return this.m_nSamples;
    }

    @OptionMetadata(displayName="Kernel bandwidth (k)", description="Kernel bandwidth", displayOrder=4)
    public void setKernelBandwidth(String band) {
        this.m_kBand = band;
    }

    public String getKernelBandwidth() {
        return this.m_kBand;
    }

    @OptionMetadata(displayName="Image width (pixels)", description="Image width in pixels", displayOrder=5)
    public void setImageWidth(int width) {
        this.m_imageWidth = width;
    }

    public int getImageWidth() {
        return this.m_imageWidth;
    }

    @OptionMetadata(displayName="Image height (pixels)", description="Image height in pixels", displayOrder=6)
    public void setImageHeight(int height) {
        this.m_imageHeight = height;
    }

    public int getImageHeight() {
        return this.m_imageHeight;
    }

    @OptionMetadata(displayName="Max image rows to compute in parallel", description="Use this many tasks for computing rows of the image", displayOrder=7)
    public void setComputeMaxRowsInParallel(int max) {
        if (max > 0) {
            this.m_maxRowsInParallel = max;
        }
    }

    public int getComputeMaxRowsInParallel() {
        return this.m_maxRowsInParallel;
    }

    @OptionMetadata(displayName="Plot training points", description="Superimpose the training data over the top of the plot", displayOrder=8)
    public void setPlotTrainingData(boolean plot) {
        this.m_plotTrainingData = plot;
    }

    public boolean getPlotTrainingData() {
        return this.m_plotTrainingData;
    }

    @Override
    public void stepInit() throws WekaException {
        List<StepManager> infos = this.getStepManager().getIncomingConnectedStepsOfConnectionType("info");
        if (infos.size() == 0) {
            throw new WekaException("One or more classifiers/clusterers need to be supplied via an 'info' connection type");
        }
        this.m_classifierTemplates = new ArrayList<weka.classifiers.Classifier>();
        this.m_clustererTemplates = new ArrayList<DensityBasedClusterer>();
        for (StepManager m : infos) {
            Step info = m.getInfoStep();
            if (info instanceof Classifier) {
                this.m_classifierTemplates.add(((Classifier)info).getClassifier());
                continue;
            }
            if (!(info instanceof Clusterer)) continue;
            weka.clusterers.Clusterer c = ((Clusterer)info).getClusterer();
            if (!(c instanceof DensityBasedClusterer)) {
                throw new WekaException("Clusterer " + c.getClass().getCanonicalName() + " is not a DensityBasedClusterer");
            }
            this.m_clustererTemplates.add((DensityBasedClusterer)c);
        }
        this.m_completedImages = new LinkedHashMap<String, BufferedImage>();
        if (this.m_nSamples != null && this.m_nSamples.length() > 0) {
            String nSampes = this.environmentSubstitute(this.m_nSamples);
            try {
                this.m_numSamplesPerRegion = Integer.parseInt(nSampes);
            }
            catch (NumberFormatException ex) {
                this.getStepManager().logWarning("Unable to parse '" + nSampes + "' for num " + "samples per region parameter, using default: " + this.m_numSamplesPerRegion);
            }
        }
        if (this.m_sBase != null && this.m_sBase.length() > 0) {
            String sBase = this.environmentSubstitute(this.m_sBase);
            try {
                this.m_samplesBase = Integer.parseInt(sBase);
            }
            catch (NumberFormatException ex) {
                this.getStepManager().logWarning("Unable to parse '" + sBase + "' for " + "the base for sampling parameter, using default: " + this.m_samplesBase);
            }
        }
        if (this.m_kBand != null && this.m_kBand.length() > 0) {
            String kBand = this.environmentSubstitute(this.m_kBand);
            try {
                this.m_kernelBandwidth = Integer.parseInt(kBand);
            }
            catch (NumberFormatException ex) {
                this.getStepManager().logWarning("Unable to parse '" + kBand + "' for kernel " + "bandwidth parameter, using default: " + this.m_kernelBandwidth);
            }
        }
        this.m_isReset = true;
    }

    protected void computeMinMaxAtts(Instances trainingData) {
        this.m_minX = Double.MAX_VALUE;
        this.m_minY = Double.MAX_VALUE;
        this.m_maxX = Double.MIN_VALUE;
        this.m_maxY = Double.MIN_VALUE;
        boolean allPointsLessThanOne = true;
        if (trainingData.numInstances() == 0) {
            this.m_minY = 0.0;
            this.m_minX = 0.0;
            this.m_maxY = 1.0;
            this.m_maxX = 1.0;
        } else {
            for (int i = 0; i < trainingData.numInstances(); ++i) {
                Instance inst = trainingData.instance(i);
                double x = inst.value(this.m_xAttribute);
                double y = inst.value(this.m_yAttribute);
                if (Utils.isMissingValue(x) || Utils.isMissingValue(y)) continue;
                if (x < this.m_minX) {
                    this.m_minX = x;
                }
                if (x > this.m_maxX) {
                    this.m_maxX = x;
                }
                if (y < this.m_minY) {
                    this.m_minY = y;
                }
                if (y > this.m_maxY) {
                    this.m_maxY = y;
                }
                if (!(x > 1.0) && !(y > 1.0)) continue;
                allPointsLessThanOne = false;
            }
        }
        if (this.m_minX == this.m_maxX) {
            this.m_minX = 0.0;
        }
        if (this.m_minY == this.m_maxY) {
            this.m_minY = 0.0;
        }
        if (this.m_minX == Double.MAX_VALUE) {
            this.m_minX = 0.0;
        }
        if (this.m_minY == Double.MAX_VALUE) {
            this.m_minY = 0.0;
        }
        if (this.m_maxX == Double.MIN_VALUE) {
            this.m_maxX = 1.0;
        }
        if (this.m_maxY == Double.MIN_VALUE) {
            this.m_maxY = 1.0;
        }
        if (allPointsLessThanOne) {
            this.m_maxY = 1.0;
            this.m_maxX = 1.0;
        }
        this.m_rangeX = this.m_maxX - this.m_minX;
        this.m_rangeY = this.m_maxY - this.m_minY;
        this.m_pixWidth = this.m_rangeX / (double)this.m_imageWidth;
        this.m_pixHeight = this.m_rangeY / (double)this.m_imageHeight;
    }

    protected int getAttIndex(String attName, Instances data) throws WekaException {
        attName = this.environmentSubstitute(attName);
        int index = -1;
        if (attName.equalsIgnoreCase("first") || attName.equalsIgnoreCase("/first")) {
            index = 0;
        } else if (attName.equalsIgnoreCase("last") || attName.equalsIgnoreCase("/last")) {
            index = data.numAttributes() - 1;
        } else {
            Attribute a2 = data.attribute(attName);
            if (a2 != null) {
                index = a2.index();
            } else {
                try {
                    index = Integer.parseInt(attName);
                    --index;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (index == -1) {
            throw new WekaException("Unable to find attribute '" + attName + "' in the data " + "or to parse it as an index");
        }
        return index;
    }

    protected void initDataGenerator(Instances trainingData) throws WekaException {
        boolean[] attsToWeightOn = new boolean[trainingData.numAttributes()];
        attsToWeightOn[this.m_xAttribute] = true;
        attsToWeightOn[this.m_yAttribute] = true;
        this.m_dataGenerator = new KDDataGenerator();
        this.m_dataGenerator.setWeightingDimensions(attsToWeightOn);
        this.m_dataGenerator.setKernelBandwidth(this.m_kernelBandwidth);
        try {
            this.m_dataGenerator.buildGenerator(trainingData);
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    @Override
    public synchronized void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        Instances training = (Instances)data.getPrimaryPayload();
        Integer setNum = data.getPayloadElement("aux_set_num", 1);
        Integer maxSetNum = data.getPayloadElement("aux_max_set_num", 1);
        this.m_xAttribute = this.getAttIndex(this.m_xAttName, training);
        this.m_yAttribute = this.getAttIndex(this.m_yAttName, training);
        this.computeMinMaxAtts(training);
        this.initDataGenerator(training);
        for (weka.classifiers.Classifier classifier : this.m_classifierTemplates) {
            if (this.isStopRequested()) {
                this.getStepManager().interrupted();
                return;
            }
            this.doScheme(classifier, null, training, setNum, maxSetNum);
        }
        for (DensityBasedClusterer densityBasedClusterer : this.m_clustererTemplates) {
            if (this.isStopRequested()) {
                this.getStepManager().interrupted();
                return;
            }
            this.doScheme(null, densityBasedClusterer, training, setNum, maxSetNum);
        }
        if (this.isStopRequested()) {
            this.getStepManager().interrupted();
        } else {
            this.getStepManager().finished();
        }
    }

    protected void doScheme(weka.classifiers.Classifier classifier, DensityBasedClusterer clust, Instances trainingData, int setNum, int maxSetNum) throws WekaException {
        try {
            this.m_osi = new BufferedImage(this.m_imageWidth, this.m_imageHeight, 1);
            this.m_currentDescription = this.makeSchemeSpec(classifier != null ? classifier : clust, setNum, maxSetNum);
            this.getStepManager().logBasic("Starting new plot for " + this.m_currentDescription);
            if (this.m_plotListener != null) {
                this.m_plotListener.newPlotStarted(this.m_currentDescription);
            }
            Graphics m = this.m_osi.getGraphics();
            m.fillRect(0, 0, this.m_imageWidth, this.m_imageHeight);
            weka.classifiers.Classifier toTrainClassifier = null;
            DensityBasedClusterer toTrainClusterer = null;
            if (classifier != null) {
                toTrainClassifier = AbstractClassifier.makeCopy(classifier);
                toTrainClassifier.buildClassifier(trainingData);
            } else {
                int tempClassIndex = trainingData.classIndex();
                trainingData.setClassIndex(-1);
                toTrainClusterer = (DensityBasedClusterer)AbstractClusterer.makeCopy(clust);
                toTrainClusterer.buildClusterer(trainingData);
                trainingData.setClassIndex(tempClassIndex);
            }
            if (toTrainClassifier != null) {
                this.m_threadClassifiers = AbstractClassifier.makeCopies(toTrainClassifier, this.m_maxRowsInParallel);
            } else {
                this.m_threadClusterers = AbstractClusterer.makeCopies(toTrainClusterer, this.m_maxRowsInParallel);
            }
            this.m_threadGenerators = new DataGenerator[this.m_maxRowsInParallel];
            SerializedObject so = new SerializedObject(this.m_dataGenerator);
            for (int i = 0; i < this.m_maxRowsInParallel; ++i) {
                this.m_threadGenerators[i] = (DataGenerator)so.getObject();
            }
            int taskCount = 0;
            ArrayList<Future<ExecutionResult<RowResult>>> results = new ArrayList<Future<ExecutionResult<RowResult>>>();
            for (int i = 0; i < this.m_imageHeight; ++i) {
                if (taskCount < this.m_maxRowsInParallel) {
                    this.getStepManager().logDetailed("Launching task to compute image row " + i);
                    SchemeRowTask schemeRowTask = new SchemeRowTask(this);
                    schemeRowTask.setResourceIntensive(this.isResourceIntensive());
                    schemeRowTask.m_classifier = null;
                    schemeRowTask.m_clusterer = null;
                    if (toTrainClassifier != null) {
                        schemeRowTask.m_classifier = this.m_threadClassifiers[taskCount];
                    } else {
                        schemeRowTask.m_clusterer = (DensityBasedClusterer)this.m_threadClusterers[taskCount];
                    }
                    schemeRowTask.m_rowNum = i;
                    schemeRowTask.m_xAtt = this.m_xAttribute;
                    schemeRowTask.m_yAtt = this.m_yAttribute;
                    schemeRowTask.m_imageWidth = this.m_imageWidth;
                    schemeRowTask.m_imageHeight = this.m_imageHeight;
                    schemeRowTask.m_pixWidth = this.m_pixWidth;
                    schemeRowTask.m_pixHeight = this.m_pixHeight;
                    schemeRowTask.m_dataGenerator = this.m_threadGenerators[taskCount];
                    schemeRowTask.m_trainingData = trainingData;
                    schemeRowTask.m_minX = this.m_minX;
                    schemeRowTask.m_maxX = this.m_maxX;
                    schemeRowTask.m_minY = this.m_minY;
                    schemeRowTask.m_maxY = this.m_maxY;
                    schemeRowTask.m_numOfSamplesPerRegion = this.m_numSamplesPerRegion;
                    schemeRowTask.m_samplesBase = this.m_samplesBase;
                    results.add(this.getStepManager().getExecutionEnvironment().submitTask(schemeRowTask));
                    ++taskCount;
                    continue;
                }
                for (Future future : results) {
                    double[][] rowProbs = ((RowResult)((ExecutionResult)future.get()).getResult()).m_rowProbs;
                    for (int j = 0; j < this.m_imageWidth; ++j) {
                        this.plotPoint(this.m_osi, j, ((RowResult)((ExecutionResult)future.get()).getResult()).m_rowNumber, rowProbs[j], j == this.m_imageWidth - 1);
                    }
                    this.getStepManager().statusMessage("Completed row " + ((RowResult)((ExecutionResult)future.get()).getResult()).m_rowNumber);
                    this.getStepManager().logDetailed("Completed image row " + ((RowResult)((ExecutionResult)future.get()).getResult()).m_rowNumber);
                }
                results.clear();
                taskCount = 0;
                if (i != this.m_imageHeight - 1) {
                    --i;
                }
                if (!this.isStopRequested()) continue;
                return;
            }
            if (results.size() > 0) {
                for (Future future : results) {
                    double[][] dArray = ((RowResult)((ExecutionResult)future.get()).getResult()).m_rowProbs;
                    for (int i = 0; i < this.m_imageWidth; ++i) {
                        this.plotPoint(this.m_osi, i, ((RowResult)((ExecutionResult)future.get()).getResult()).m_rowNumber, dArray[i], i == this.m_imageWidth - 1);
                    }
                    this.getStepManager().statusMessage("Completed row " + ((RowResult)((ExecutionResult)future.get()).getResult()).m_rowNumber);
                    this.getStepManager().logDetailed("Completed image row " + ((RowResult)((ExecutionResult)future.get()).getResult()).m_rowNumber);
                }
                if (this.isStopRequested()) {
                    return;
                }
            }
            if (this.m_plotTrainingData) {
                this.plotTrainingData(trainingData);
            }
            this.m_completedImages.put(this.m_currentDescription, this.m_osi);
            Data imageOut = new Data("image", this.m_osi);
            imageOut.setPayloadElement("aux_textTitle", this.m_currentDescription);
            this.getStepManager().outputData(imageOut);
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    protected String makeSchemeSpec(Object scheme, int setNum, int maxSetNum) {
        String name = scheme.getClass().getCanonicalName();
        name = name.substring(name.lastIndexOf(46) + 1, name.length());
        if (scheme instanceof OptionHandler) {
            name = name + " " + Utils.joinOptions(((OptionHandler)scheme).getOptions());
        }
        if (maxSetNum != 1) {
            name = name + " (set " + setNum + " of " + maxSetNum + ")";
        }
        return name;
    }

    protected void plotPoint(BufferedImage osi, int x, int y, double[] probs, boolean update) {
        Graphics osg = osi.getGraphics();
        osg.setPaintMode();
        float[] colVal = new float[3];
        float[] tempCols = new float[3];
        for (int k = 0; k < probs.length; ++k) {
            Color curr = this.m_Colors.get(k % this.m_Colors.size());
            curr.getRGBColorComponents(tempCols);
            for (int z = 0; z < 3; ++z) {
                int n = z;
                colVal[n] = (float)((double)colVal[n] + probs[k] * (double)tempCols[z]);
            }
        }
        for (int z = 0; z < 3; ++z) {
            if (colVal[z] < 0.0f) {
                colVal[z] = 0.0f;
                continue;
            }
            if (!(colVal[z] > 1.0f)) continue;
            colVal[z] = 1.0f;
        }
        osg.setColor(new Color(colVal[0], colVal[1], colVal[2]));
        osg.fillRect(x, y, 1, 1);
        if (update && this.m_plotListener != null) {
            this.m_plotListener.currentPlotRowCompleted(y);
        }
    }

    public void plotTrainingData(Instances trainingData) {
        Graphics2D osg = (Graphics2D)this.m_osi.getGraphics();
        osg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double xval = 0.0;
        double yval = 0.0;
        for (int i = 0; i < trainingData.numInstances(); ++i) {
            if (trainingData.instance(i).isMissing(this.m_xAttribute) || trainingData.instance(i).isMissing(this.m_yAttribute)) continue;
            xval = trainingData.instance(i).value(this.m_xAttribute);
            yval = trainingData.instance(i).value(this.m_yAttribute);
            int panelX = this.convertToImageX(xval);
            int panelY = this.convertToImageY(yval);
            Color colorToPlotWith = Color.white;
            if (trainingData.classIndex() > 0) {
                colorToPlotWith = this.m_Colors.get((int)trainingData.instance(i).value(trainingData.classIndex()) % this.m_Colors.size());
            }
            if (colorToPlotWith.equals(Color.white)) {
                osg.setColor(Color.black);
            } else {
                osg.setColor(Color.white);
            }
            osg.fillOval(panelX - 3, panelY - 3, 7, 7);
            osg.setColor(colorToPlotWith);
            osg.fillOval(panelX - 2, panelY - 2, 5, 5);
        }
        if (this.m_plotListener != null) {
            this.m_plotListener.renderingImageUpdate();
        }
    }

    private int convertToImageX(double xval) {
        double temp = (xval - this.m_minX) / this.m_rangeX;
        return (int)(temp *= (double)this.m_imageWidth);
    }

    private int convertToImageY(double yval) {
        double temp = (yval - this.m_minY) / this.m_rangeY;
        temp *= (double)this.m_imageHeight;
        temp = (double)this.m_imageHeight - temp;
        return (int)temp;
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("dataSet", "trainingSet", "info");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return Arrays.asList("image");
    }

    public Map<String, BufferedImage> getImages() {
        return this.m_completedImages;
    }

    public BufferedImage getCurrentImage() {
        return this.m_osi;
    }

    public void setRenderingListener(RenderingUpdateListener l) {
        this.m_plotListener = l;
    }

    public void removeRenderingListener(RenderingUpdateListener l) {
        if (l == this.m_plotListener) {
            this.m_plotListener = null;
        }
    }

    @Override
    public Map<String, String> getInteractiveViewers() {
        LinkedHashMap<String, String> views = new LinkedHashMap<String, String>();
        if (this.m_plotListener == null) {
            views.put("Show plots", "weka.gui.knowledgeflow.steps.BoundaryPlotterInteractiveView");
        }
        return views;
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.BoundaryPlotterStepEditorDialog";
    }

    @Override
    public Object retrieveData() {
        return ImageViewer.bufferedImageMapToSerializableByteMap(this.m_completedImages);
    }

    @Override
    public void restoreData(Object data) throws WekaException {
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("Argument must be a Map");
        }
        try {
            this.m_completedImages = ImageViewer.byteArrayImageMapToBufferedImageMap((Map)data);
        }
        catch (IOException ex) {
            throw new WekaException(ex);
        }
    }

    protected static class SchemeRowTask
    extends StepTask<RowResult>
    implements Serializable {
        private static final long serialVersionUID = -4144732293602550066L;
        protected int m_xAtt;
        protected int m_yAtt;
        protected int m_rowNum;
        protected int m_imageWidth;
        protected int m_imageHeight;
        protected double m_pixWidth;
        protected double m_pixHeight;
        protected weka.classifiers.Classifier m_classifier;
        protected DensityBasedClusterer m_clusterer;
        protected DataGenerator m_dataGenerator;
        protected Instances m_trainingData;
        protected double m_minX;
        protected double m_maxX;
        protected double m_minY;
        protected double m_maxY;
        protected int m_numOfSamplesPerRegion;
        protected double m_samplesBase;
        private Random m_random;
        private int m_numOfSamplesPerGenerator;
        private boolean[] m_attsToWeightOn;
        private double[] m_weightingAttsValues;
        private double[] m_vals;
        private double[] m_dist;
        Instance m_predInst;

        public SchemeRowTask(Step source) {
            super(source);
        }

        @Override
        public void process() throws Exception {
            RowResult result = new RowResult();
            result.m_rowNumber = this.m_rowNum;
            result.m_rowProbs = new double[this.m_imageWidth][0];
            this.m_random = new Random(this.m_rowNum * 11);
            this.m_dataGenerator.setSeed(this.m_rowNum * 11);
            this.m_numOfSamplesPerGenerator = (int)Math.pow(this.m_samplesBase, this.m_trainingData.numAttributes() - 3);
            if (this.m_trainingData == null) {
                throw new Exception("No training data set");
            }
            if (this.m_classifier == null && this.m_clusterer == null) {
                throw new Exception("No scheme set");
            }
            if (this.m_dataGenerator == null) {
                throw new Exception("No data generator set");
            }
            if (this.m_trainingData.attribute(this.m_xAtt).isNominal() || this.m_trainingData.attribute(this.m_yAtt).isNominal()) {
                throw new Exception("Visualization dimensions must be numeric");
            }
            this.m_attsToWeightOn = new boolean[this.m_trainingData.numAttributes()];
            this.m_attsToWeightOn[this.m_xAtt] = true;
            this.m_attsToWeightOn[this.m_yAtt] = true;
            this.m_weightingAttsValues = new double[this.m_attsToWeightOn.length];
            this.m_vals = new double[this.m_trainingData.numAttributes()];
            this.m_predInst = new DenseInstance(1.0, this.m_vals);
            this.m_predInst.setDataset(this.m_trainingData);
            this.getLogHandler().logDetailed("Computing row number: " + this.m_rowNum);
            for (int j = 0; j < this.m_imageWidth; ++j) {
                double[] preds = this.calculateRegionProbs(j, this.m_rowNum);
                result.m_rowProbs[j] = preds;
            }
            this.getExecutionResult().setResult(result);
        }

        private double[] calculateRegionProbs(int j, int i) throws Exception {
            double[] sumOfProbsForRegion = new double[this.m_classifier != null ? this.m_trainingData.classAttribute().numValues() : this.m_clusterer.numberOfClusters()];
            double sumOfSums = 0.0;
            for (int u = 0; u < this.m_numOfSamplesPerRegion; ++u) {
                int z;
                double[] sumOfProbsForLocation = new double[this.m_classifier != null ? this.m_trainingData.classAttribute().numValues() : this.m_clusterer.numberOfClusters()];
                this.m_weightingAttsValues[this.m_xAtt] = this.getRandomX(j);
                this.m_weightingAttsValues[this.m_yAtt] = this.getRandomY(this.m_imageHeight - i - 1);
                this.m_dataGenerator.setWeightingValues(this.m_weightingAttsValues);
                double[] weights = this.m_dataGenerator.getWeights();
                double sumOfWeights = Utils.sum(weights);
                sumOfSums += sumOfWeights;
                int[] indices = Utils.sort(weights);
                int[] newIndices = new int[indices.length];
                double sumSoFar = 0.0;
                double criticalMass = 0.99 * sumOfWeights;
                int index = weights.length - 1;
                int counter = 0;
                for (z = weights.length - 1; z >= 0; --z) {
                    newIndices[index--] = indices[z];
                    ++counter;
                    if ((sumSoFar += weights[indices[z]]) > criticalMass) break;
                }
                indices = new int[counter];
                System.arraycopy(newIndices, index + 1, indices, 0, counter);
                for (z = 0; z < this.m_numOfSamplesPerGenerator; ++z) {
                    this.m_dataGenerator.setWeightingValues(this.m_weightingAttsValues);
                    double[][] values = this.m_dataGenerator.generateInstances(indices);
                    for (int q = 0; q < values.length; ++q) {
                        if (values[q] == null) continue;
                        System.arraycopy(values[q], 0, this.m_vals, 0, this.m_vals.length);
                        this.m_vals[this.m_xAtt] = this.m_weightingAttsValues[this.m_xAtt];
                        this.m_vals[this.m_yAtt] = this.m_weightingAttsValues[this.m_yAtt];
                        this.m_dist = this.m_classifier != null ? this.m_classifier.distributionForInstance(this.m_predInst) : this.m_clusterer.distributionForInstance(this.m_predInst);
                        for (int k = 0; k < sumOfProbsForLocation.length; ++k) {
                            int n = k;
                            sumOfProbsForLocation[n] = sumOfProbsForLocation[n] + this.m_dist[k] * weights[q];
                        }
                    }
                }
                for (int k = 0; k < sumOfProbsForRegion.length; ++k) {
                    int n = k;
                    sumOfProbsForRegion[n] = sumOfProbsForRegion[n] + sumOfProbsForLocation[k] / (double)this.m_numOfSamplesPerGenerator;
                }
            }
            if (!(sumOfSums > 0.0)) {
                throw new Exception("Arithmetic underflow. Please increase value of kernel bandwidth parameter (k).");
            }
            Utils.normalize(sumOfProbsForRegion, sumOfSums);
            double[] tempDist = new double[sumOfProbsForRegion.length];
            System.arraycopy(sumOfProbsForRegion, 0, tempDist, 0, sumOfProbsForRegion.length);
            return tempDist;
        }

        private double getRandomX(int pix) {
            double minPix = this.m_minX + (double)pix * this.m_pixWidth;
            return minPix + this.m_random.nextDouble() * this.m_pixWidth;
        }

        private double getRandomY(int pix) {
            double minPix = this.m_minY + (double)pix * this.m_pixHeight;
            return minPix + this.m_random.nextDouble() * this.m_pixHeight;
        }
    }

    protected static class RowResult {
        protected double[][] m_rowProbs;
        protected int m_rowNumber;

        protected RowResult() {
        }
    }

    public static interface RenderingUpdateListener {
        public void newPlotStarted(String var1);

        public void currentPlotRowCompleted(int var1);

        public void renderingImageUpdate();
    }
}

