/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.Arrays;
import java.util.List;
import weka.core.Environment;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.JobEnvironment;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="WriteDataToResult", category="Flow", toolTipText="Write incoming non-incremental data to the results store in the job environment", iconPath="weka/gui/knowledgeflow/icons/WriteDataToResult.gif")
public class WriteDataToResult
extends BaseStep {
    private static final long serialVersionUID = -1932252461151862615L;

    @Override
    public void stepInit() throws WekaException {
        Environment env = this.getStepManager().getExecutionEnvironment().getEnvironmentVariables();
        if (!(env instanceof JobEnvironment)) {
            JobEnvironment jobEnvironment = new JobEnvironment(env);
            this.getStepManager().getExecutionEnvironment().setEnvironmentVariables(jobEnvironment);
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        JobEnvironment jobEnvironment = (JobEnvironment)this.getStepManager().getExecutionEnvironment().getEnvironmentVariables();
        this.getStepManager().logDetailed("Storing " + data.getConnectionName() + " in " + "result");
        jobEnvironment.addToResult(data);
        this.getStepManager().finished();
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("dataSet", "trainingSet", "testSet", "batchClassifier", "batchClusterer", "batchAssociator", "text", "image");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return null;
    }
}

