/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.dmopso;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.dmopso.DMOPSO;
import org.uma.jmetal.measure.Measurable;
import org.uma.jmetal.measure.MeasureManager;
import org.uma.jmetal.measure.impl.BasicMeasure;
import org.uma.jmetal.measure.impl.CountingMeasure;
import org.uma.jmetal.measure.impl.DurationMeasure;
import org.uma.jmetal.measure.impl.SimpleMeasureManager;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;

public class DMOPSOMeasures
extends DMOPSO
implements Measurable {
    protected CountingMeasure iterations;
    protected DurationMeasure durationMeasure;
    protected SimpleMeasureManager measureManager;
    protected BasicMeasure<List<DoubleSolution>> solutionListMeasure;
    protected BasicMeasure<Double> hypervolumeValue;
    protected BasicMeasure<Double> epsilonValue;
    protected Front referenceFront = new ArrayFront();

    public DMOPSOMeasures(DoubleProblem problem, int swarmSize, int maxIterations, double r1Min, double r1Max, double r2Min, double r2Max, double c1Min, double c1Max, double c2Min, double c2Max, double weightMin, double weightMax, double changeVelocity1, double changeVelocity2, DMOPSO.FunctionType functionType, String dataDirectory, int maxAge) {
        this(problem, swarmSize, maxIterations, r1Min, r1Max, r2Min, r2Max, c1Min, c1Max, c2Min, c2Max, weightMin, weightMax, changeVelocity1, changeVelocity2, functionType, dataDirectory, maxAge, "dMOPSO");
    }

    public DMOPSOMeasures(DoubleProblem problem, int swarmSize, int maxIterations, double r1Min, double r1Max, double r2Min, double r2Max, double c1Min, double c1Max, double c2Min, double c2Max, double weightMin, double weightMax, double changeVelocity1, double changeVelocity2, DMOPSO.FunctionType functionType, String dataDirectory, int maxAge, String name) {
        super(problem, swarmSize, maxIterations, r1Min, r1Max, r2Min, r2Max, c1Min, c1Max, c2Min, c2Max, weightMin, weightMax, changeVelocity1, changeVelocity2, functionType, dataDirectory, maxAge, name);
        this.initMeasures();
    }

    @Override
    protected void initProgress() {
        this.iterations.reset();
    }

    @Override
    protected void updateProgress() {
        this.iterations.increment();
        this.hypervolumeValue.push(new PISAHypervolume(this.referenceFront).evaluate(this.getResult()));
        this.epsilonValue.push(new Epsilon(this.referenceFront).evaluate(this.getResult()));
        this.solutionListMeasure.push((List<DoubleSolution>)this.getResult());
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.iterations.get() >= (long)this.maxIterations;
    }

    @Override
    public void run() {
        this.durationMeasure.reset();
        this.durationMeasure.start();
        super.run();
        this.durationMeasure.stop();
    }

    private void initMeasures() {
        this.durationMeasure = new DurationMeasure();
        this.iterations = new CountingMeasure(0L);
        this.solutionListMeasure = new BasicMeasure();
        this.hypervolumeValue = new BasicMeasure();
        this.epsilonValue = new BasicMeasure();
        this.measureManager = new SimpleMeasureManager();
        this.measureManager.setPullMeasure("currentExecutionTime", this.durationMeasure);
        this.measureManager.setPullMeasure("currentEvaluation", this.iterations);
        this.measureManager.setPullMeasure("hypervolume", this.hypervolumeValue);
        this.measureManager.setPullMeasure("epsilon", this.epsilonValue);
        this.measureManager.setPushMeasure("currentPopulation", this.solutionListMeasure);
        this.measureManager.setPushMeasure("currentEvaluation", this.iterations);
        this.measureManager.setPushMeasure("hypervolume", this.hypervolumeValue);
        this.measureManager.setPushMeasure("epsilon", this.epsilonValue);
    }

    @Override
    public String getDescription() {
        return "MOPSO with decomposition. Version using measures";
    }

    @Override
    public MeasureManager getMeasureManager() {
        return this.measureManager;
    }

    public void setReferenceFront(Front referenceFront) {
        this.referenceFront = referenceFront;
    }
}

