/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.espea;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.espea.ESPEA;
import org.uma.jmetal.algorithm.multiobjective.espea.util.EnergyArchive;
import org.uma.jmetal.algorithm.multiobjective.espea.util.ScalarizationWrapper;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.selection.RandomSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.AlgorithmBuilder;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class ESPEABuilder<S extends Solution<?>>
implements AlgorithmBuilder<ESPEA<S>> {
    private final Problem<S> problem;
    private int maxEvaluations;
    private int populationSize;
    private CrossoverOperator<S> crossoverOperator;
    private CrossoverOperator<S> fullArchiveCrossoverOperator;
    private MutationOperator<S> mutationOperator;
    private SelectionOperator<List<S>, S> selectionOperator;
    private SolutionListEvaluator<S> evaluator;
    private ScalarizationWrapper scalarization;
    private boolean normalizeObjectives;
    private EnergyArchive.ReplacementStrategy replacementStrategy;

    public ESPEABuilder(Problem<S> problem, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator) {
        this.problem = problem;
        this.maxEvaluations = 25000;
        this.populationSize = 100;
        this.crossoverOperator = crossoverOperator;
        this.fullArchiveCrossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = new RandomSelection();
        this.evaluator = new SequentialSolutionListEvaluator();
        this.scalarization = new ScalarizationWrapper(ScalarizationWrapper.ScalarizationType.UNIFORM);
        this.normalizeObjectives = true;
        this.replacementStrategy = EnergyArchive.ReplacementStrategy.LARGEST_DIFFERENCE;
    }

    @Override
    public ESPEA<S> build() {
        return new ESPEA<S>(this.problem, this.maxEvaluations, this.populationSize, this.crossoverOperator, this.fullArchiveCrossoverOperator, this.mutationOperator, this.selectionOperator, this.scalarization, this.evaluator, this.normalizeObjectives, this.replacementStrategy);
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public CrossoverOperator<S> getCrossoverOperator() {
        return this.crossoverOperator;
    }

    public CrossoverOperator<S> getFullArchiveCrossoverOperator() {
        return this.fullArchiveCrossoverOperator;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }

    public SelectionOperator<List<S>, S> getSelectionOperator() {
        return this.selectionOperator;
    }

    public SolutionListEvaluator<S> getEvaluator() {
        return this.evaluator;
    }

    public ScalarizationWrapper getScalarization() {
        return this.scalarization;
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
    }

    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public void setCrossoverOperator(CrossoverOperator<S> crossoverOperator) {
        this.crossoverOperator = crossoverOperator;
    }

    public void setFullArchiveCrossoverOperator(CrossoverOperator<S> fullArchiveCrossoverOperator) {
        this.fullArchiveCrossoverOperator = fullArchiveCrossoverOperator;
    }

    public void setMutationOperator(MutationOperator<S> mutationOperator) {
        this.mutationOperator = mutationOperator;
    }

    public void setSelectionOperator(SelectionOperator<List<S>, S> selectionOperator) {
        this.selectionOperator = selectionOperator;
    }

    public void setEvaluator(SolutionListEvaluator<S> evaluator) {
        this.evaluator = evaluator;
    }

    public void setScalarization(ScalarizationWrapper scalarization) {
        this.scalarization = scalarization;
    }

    public boolean isNormalizeObjectives() {
        return this.normalizeObjectives;
    }

    public void setNormalizeObjectives(boolean normalizeObjectives) {
        this.normalizeObjectives = normalizeObjectives;
    }

    public EnergyArchive.ReplacementStrategy getOperationType() {
        return this.replacementStrategy;
    }

    public void setReplacementStrategy(EnergyArchive.ReplacementStrategy replacementStrategy) {
        this.replacementStrategy = replacementStrategy;
    }
}

