/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.espea.util;

import java.util.Collections;
import java.util.Comparator;
import org.uma.jmetal.algorithm.multiobjective.espea.util.ScalarizationValue;
import org.uma.jmetal.algorithm.multiobjective.espea.util.ScalarizationWrapper;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.comparator.FitnessComparator;
import org.uma.jmetal.util.front.util.FrontNormalizer;
import org.uma.jmetal.util.solutionattribute.impl.Fitness;

public class EnergyArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    private final ScalarizationValue<S> scalarization = new ScalarizationValue();
    private final Fitness<S> fitness = new Fitness();
    private final Comparator<S> fitnessComparator = new FitnessComparator();
    private final ScalarizationWrapper scalWrapper;
    private ReplacementStrategy replacementStrategy = ReplacementStrategy.LARGEST_DIFFERENCE;
    private boolean normalizeObjectives = true;

    public EnergyArchive(int maxSize) {
        this(maxSize, new ScalarizationWrapper(ScalarizationWrapper.ScalarizationType.UNIFORM));
    }

    public EnergyArchive(int maxSize, ScalarizationWrapper scalWrapper) {
        super(maxSize);
        this.scalWrapper = scalWrapper;
    }

    public EnergyArchive(int maxSize, ScalarizationWrapper scalWrapper, boolean normalizeObjectives) {
        super(maxSize);
        this.scalWrapper = scalWrapper;
        this.normalizeObjectives = normalizeObjectives;
    }

    public EnergyArchive(int maxSize, ScalarizationWrapper scalWrapper, boolean normalizeObjectives, ReplacementStrategy replacementStrategy) {
        super(maxSize);
        this.scalWrapper = scalWrapper;
        this.normalizeObjectives = normalizeObjectives;
        this.replacementStrategy = replacementStrategy;
    }

    @Override
    public Comparator<S> getComparator() {
        return this.fitnessComparator;
    }

    @Override
    public void computeDensityEstimator() {
        double[][] distanceMatrix;
        this.scalWrapper.execute(this.getSolutionList());
        this.scaleToPositive();
        if (this.normalizeObjectives) {
            FrontNormalizer normalizer = new FrontNormalizer(this.getSolutionList());
            distanceMatrix = SolutionListUtils.distanceMatrix(normalizer.normalize(this.getSolutionList()));
        } else {
            distanceMatrix = SolutionListUtils.distanceMatrix(this.getSolutionList());
        }
        double[] energyVector = this.energyVector(distanceMatrix);
        double[] replacementVector = this.replacementVector(distanceMatrix);
        boolean eligible = false;
        for (int i = 0; i < replacementVector.length; ++i) {
            if (replacementVector[i] < energyVector[i]) {
                eligible = true;
                switch (this.replacementStrategy) {
                    case BEST_FEASIBLE_POSITION: {
                        this.fitness.setAttribute(this.archive.get(i), -replacementVector[i]);
                        break;
                    }
                    case LARGEST_DIFFERENCE: {
                        this.fitness.setAttribute(this.archive.get(i), energyVector[i]);
                        break;
                    }
                    case WORST_IN_ARCHIVE: {
                        this.fitness.setAttribute(this.archive.get(i), energyVector[i] - replacementVector[i]);
                    }
                }
            } else {
                this.archive.get(i).setAttribute(this.fitness.getAttributeIdentifier(), -1.7976931348623157E308);
            }
            if (eligible) {
                this.fitness.setAttribute(this.archive.get(this.maxSize), -1.7976931348623157E308);
                continue;
            }
            this.fitness.setAttribute(this.archive.get(this.maxSize), Double.MAX_VALUE);
        }
    }

    @Override
    public void sortByDensityEstimator() {
        Collections.sort(this.getSolutionList(), this.fitnessComparator);
    }

    @Override
    public void prune() {
        if (this.getSolutionList().size() > this.getMaxSize()) {
            this.computeDensityEstimator();
            Solution worst = (Solution)new SolutionListUtils().findWorstSolution(this.getSolutionList(), this.fitnessComparator);
            this.getSolutionList().remove(worst);
        }
    }

    private void scaleToPositive() {
        double minScalarization = Double.MAX_VALUE;
        for (Solution solution : this.getSolutionList()) {
            if (!((Double)this.scalarization.getAttribute(solution) < minScalarization)) continue;
            minScalarization = (Double)this.scalarization.getAttribute(solution);
        }
        if (minScalarization < 0.0) {
            double eps = 1.0E-5;
            for (Solution solution : this.getSolutionList()) {
                this.scalarization.setAttribute(solution, eps + (Double)this.scalarization.getAttribute(solution) + minScalarization);
            }
        }
    }

    private double[] energyVector(double[][] distanceMatrix) {
        double[] energyVector = new double[distanceMatrix.length - 1];
        for (int i = 0; i < energyVector.length - 1; ++i) {
            for (int j = i + 1; j < energyVector.length; ++j) {
                int n = i;
                energyVector[n] = energyVector[n] + (Double)this.scalarization.getAttribute(this.archive.get(j)) / distanceMatrix[i][j];
                int n2 = j;
                energyVector[n2] = energyVector[n2] + (Double)this.scalarization.getAttribute(this.archive.get(i)) / distanceMatrix[i][j];
            }
            int n = i;
            energyVector[n] = energyVector[n] * (Double)this.scalarization.getAttribute(this.archive.get(i));
        }
        return energyVector;
    }

    private double[] replacementVector(double[][] distanceMatrix) {
        int i;
        double[] replacementVector = new double[distanceMatrix.length - 1];
        double[] individualEnergy = new double[distanceMatrix.length - 1];
        double totalEnergy = 0.0;
        for (i = 0; i < replacementVector.length; ++i) {
            individualEnergy[i] = (Double)this.scalarization.getAttribute(this.archive.get(i)) / distanceMatrix[i][this.maxSize];
            totalEnergy += individualEnergy[i];
        }
        i = 0;
        while (i < individualEnergy.length) {
            replacementVector[i] = totalEnergy - individualEnergy[i];
            int n = i++;
            replacementVector[n] = replacementVector[n] * (Double)this.scalarization.getAttribute(this.archive.get(this.maxSize));
        }
        return replacementVector;
    }

    public boolean isFull() {
        return this.getSolutionList().size() == this.maxSize;
    }

    public static enum ReplacementStrategy {
        BEST_FEASIBLE_POSITION,
        LARGEST_DIFFERENCE,
        WORST_IN_ARCHIVE;

    }
}

