/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.espea.util;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.espea.util.ScalarizationUtils;
import org.uma.jmetal.solution.Solution;

public class ScalarizationWrapper {
    private final Config config;

    public ScalarizationWrapper(ScalarizationType scalarizationType) {
        Config config = new Config();
        config.scalarizationType = scalarizationType;
        this.config = config;
    }

    public ScalarizationWrapper(Config config) {
        this.config = config;
    }

    public <S extends Solution<?>> void execute(List<S> solutionsList) {
        switch (this.config.scalarizationType) {
            case ANGLE_UTILITY: {
                if (this.config.extremePoints == null) {
                    ScalarizationUtils.angleUtility(solutionsList);
                    break;
                }
                ScalarizationUtils.angleUtility(solutionsList, this.config.extremePoints);
                break;
            }
            case CHEBYSHEV: {
                if (this.config.idealValues == null) {
                    ScalarizationUtils.chebyshev(solutionsList);
                    break;
                }
                ScalarizationUtils.chebyshev(solutionsList, this.config.idealValues);
                break;
            }
            case NASH: {
                if (this.config.nadirValues == null) {
                    ScalarizationUtils.nash(solutionsList);
                    break;
                }
                ScalarizationUtils.nash(solutionsList, this.config.nadirValues);
                break;
            }
            case SUM_OF_OBJECTIVES: {
                ScalarizationUtils.sumOfObjectives(solutionsList);
                break;
            }
            case PRODUCT_OF_OBJECTIVES: {
                ScalarizationUtils.productOfObjectives(solutionsList);
                break;
            }
            case TRADEOFF_UTILITY: {
                ScalarizationUtils.tradeoffUtility(solutionsList);
                break;
            }
            case UNIFORM: {
                ScalarizationUtils.uniform(solutionsList);
                break;
            }
            case WEIGHTED_CHEBYSHEV: {
                if (this.config.idealValues == null) {
                    ScalarizationUtils.weightedChebyshev(solutionsList, this.config.weights);
                    break;
                }
                ScalarizationUtils.weightedChebyshev(solutionsList, this.config.idealValues, this.config.weights);
                break;
            }
            case WEIGHTED_PRODUCT: {
                ScalarizationUtils.weightedProduct(solutionsList, this.config.weights);
                break;
            }
            case WEIGHTED_SUM: {
                ScalarizationUtils.weightedSum(solutionsList, this.config.weights);
            }
        }
    }

    public static class Config {
        private ScalarizationType scalarizationType;
        private double[] weights;
        private double[] idealValues;
        private double[] nadirValues;
        private double[][] extremePoints;
        private double[][] referenceSet;
    }

    public static enum ScalarizationType {
        ANGLE_UTILITY,
        CHEBYSHEV,
        NASH,
        PRODUCT_OF_OBJECTIVES,
        SUM_OF_OBJECTIVES,
        TRADEOFF_UTILITY,
        UNIFORM,
        WEIGHTED_SUM,
        WEIGHTED_PRODUCT,
        WEIGHTED_CHEBYSHEV;

    }
}

