/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mochc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class MOCHC45
implements Algorithm<List<BinarySolution>> {
    private BinaryProblem problem;
    private List<BinarySolution> population;
    private int populationSize;
    private int maxEvaluations;
    private int convergenceValue;
    private double preservedPopulation;
    private double initialConvergenceCount;
    private CrossoverOperator<BinarySolution> crossover;
    private MutationOperator<BinarySolution> cataclysmicMutation;
    private SelectionOperator<List<BinarySolution>, List<BinarySolution>> newGenerationSelection;
    private SelectionOperator<List<BinarySolution>, BinarySolution> parentSelection;
    private int evaluations;
    private int minimumDistance;
    private int size;
    private Comparator<BinarySolution> comparator;

    public MOCHC45(BinaryProblem problem, int populationSize, int maxEvaluations, int convergenceValue, double preservedPopulation, double initialConvergenceCount, CrossoverOperator<BinarySolution> crossoverOperator, MutationOperator<BinarySolution> cataclysmicMutation, SelectionOperator<List<BinarySolution>, List<BinarySolution>> newGenerationSelection, SelectionOperator<List<BinarySolution>, BinarySolution> parentSelection, SolutionListEvaluator<BinarySolution> evaluator) {
        this.problem = problem;
        this.populationSize = populationSize;
        this.maxEvaluations = maxEvaluations;
        this.convergenceValue = convergenceValue;
        this.preservedPopulation = preservedPopulation;
        this.initialConvergenceCount = initialConvergenceCount;
        this.crossover = crossoverOperator;
        this.cataclysmicMutation = cataclysmicMutation;
        this.newGenerationSelection = newGenerationSelection;
        this.parentSelection = parentSelection;
    }

    @Override
    public String getName() {
        return "MOCHC45";
    }

    @Override
    public String getDescription() {
        return "Multiobjective CHC algorithm";
    }

    @Override
    public void run() {
        int i;
        for (i = 0; i < this.problem.getNumberOfVariables(); ++i) {
            this.size += this.problem.getNumberOfBits(i);
        }
        this.minimumDistance = (int)Math.floor(this.initialConvergenceCount * (double)this.size);
        this.comparator = new CrowdingDistanceComparator<BinarySolution>();
        this.evaluations = 0;
        this.population = new ArrayList<BinarySolution>();
        for (i = 0; i < this.populationSize; ++i) {
            BinarySolution newIndividual = (BinarySolution)this.problem.createSolution();
            this.problem.evaluate(newIndividual);
            this.population.add(newIndividual);
            ++this.evaluations;
        }
        boolean finishCondition = false;
        while (!finishCondition) {
            ArrayList offspringPopulation = new ArrayList(this.populationSize);
            for (int i2 = 0; i2 < this.population.size() / 2; ++i2) {
                ArrayList parents = new ArrayList(2);
                parents.add(this.parentSelection.execute(this.population));
                parents.add(this.parentSelection.execute(this.population));
                if (this.hammingDistance((BinarySolution)parents.get(0), (BinarySolution)parents.get(1)) < this.minimumDistance) continue;
                List offspring = (List)this.crossover.execute((BinarySolution)((Object)parents));
                this.problem.evaluate(offspring.get(0));
                this.problem.evaluate(offspring.get(1));
                offspringPopulation.add(offspring.get(0));
                offspringPopulation.add(offspring.get(1));
                this.evaluations += 2;
            }
            ArrayList<BinarySolution> union = new ArrayList<BinarySolution>();
            union.addAll(this.population);
            union.addAll(offspringPopulation);
            ArrayList<BinarySolution> newPopulation = (ArrayList<BinarySolution>)this.newGenerationSelection.execute(union);
            if (SolutionListUtils.solutionListsAreEquals(this.population, newPopulation)) {
                --this.minimumDistance;
            }
            if (this.minimumDistance <= -this.convergenceValue) {
                int i3;
                this.minimumDistance = (int)(1.0 / (double)this.size * (1.0 - 1.0 / (double)this.size) * (double)this.size);
                int preserve = (int)Math.floor(this.preservedPopulation * (double)this.population.size());
                newPopulation = new ArrayList<BinarySolution>(this.populationSize);
                Collections.sort(this.population, this.comparator);
                for (i3 = 0; i3 < preserve; ++i3) {
                    newPopulation.add((BinarySolution)this.population.get(i3).copy());
                }
                for (i3 = preserve; i3 < this.populationSize; ++i3) {
                    BinarySolution solution = (BinarySolution)this.population.get(i3).copy();
                    this.cataclysmicMutation.execute(solution);
                    this.problem.evaluate(solution);
                    newPopulation.add(solution);
                    ++this.evaluations;
                }
            }
            this.population = newPopulation;
            if (this.evaluations < this.maxEvaluations) continue;
            finishCondition = true;
        }
    }

    @Override
    public List<BinarySolution> getResult() {
        NonDominatedSolutionListArchive<BinarySolution> archive = new NonDominatedSolutionListArchive<BinarySolution>();
        for (BinarySolution solution : this.population) {
            archive.add(solution);
        }
        return archive.getSolutionList();
    }

    private int hammingDistance(BinarySolution solutionOne, BinarySolution solutionTwo) {
        int distance = 0;
        for (int i = 0; i < this.problem.getNumberOfVariables(); ++i) {
            distance += this.hammingDistance((BinarySet)solutionOne.getVariableValue(i), (BinarySet)solutionTwo.getVariableValue(i));
        }
        return distance;
    }

    private int hammingDistance(BinarySet bitSet1, BinarySet bitSet2) {
        if (bitSet1.getBinarySetLength() != bitSet2.getBinarySetLength()) {
            throw new JMetalException("The bitsets have different length: " + bitSet1.getBinarySetLength() + ", " + bitSet2.getBinarySetLength());
        }
        int distance = 0;
        for (int i = 0; i < bitSet1.getBinarySetLength(); ++i) {
            if (bitSet1.get(i) == bitSet2.get(i)) continue;
            ++distance;
        }
        return distance;
    }
}

