/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.moead;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.util.MOEADUtils;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.problem.ConstrainedProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.impl.ViolationThresholdComparator;

public class ConstraintMOEAD
extends AbstractMOEAD<DoubleSolution> {
    private DifferentialEvolutionCrossover differentialEvolutionCrossover;
    private ViolationThresholdComparator<DoubleSolution> violationThresholdComparator;

    public ConstraintMOEAD(Problem<DoubleSolution> problem, int populationSize, int resultPopulationSize, int maxEvaluations, MutationOperator<DoubleSolution> mutation, CrossoverOperator<DoubleSolution> crossover, AbstractMOEAD.FunctionType functionType, String dataDirectory, double neighborhoodSelectionProbability, int maximumNumberOfReplacedSolutions, int neighborSize) {
        super(problem, populationSize, resultPopulationSize, maxEvaluations, crossover, mutation, functionType, dataDirectory, neighborhoodSelectionProbability, maximumNumberOfReplacedSolutions, neighborSize);
        this.differentialEvolutionCrossover = (DifferentialEvolutionCrossover)this.crossoverOperator;
        this.violationThresholdComparator = new ViolationThresholdComparator();
    }

    @Override
    public void run() {
        this.initializeUniformWeight();
        this.initializeNeighborhood();
        this.initializePopulation();
        this.initializeIdealPoint();
        this.violationThresholdComparator.updateThreshold(this.population);
        this.evaluations = this.populationSize;
        do {
            int[] permutation = new int[this.populationSize];
            MOEADUtils.randomPermutation(permutation, this.populationSize);
            for (int i = 0; i < this.populationSize; ++i) {
                int subProblemId = permutation[i];
                AbstractMOEAD.NeighborType neighborType = this.chooseNeighborType();
                List<DoubleSolution> parents = this.parentSelection(subProblemId, neighborType);
                this.differentialEvolutionCrossover.setCurrentSolution((DoubleSolution)this.population.get(subProblemId));
                List<DoubleSolution> children = this.differentialEvolutionCrossover.execute(parents);
                DoubleSolution child = children.get(0);
                this.mutationOperator.execute(child);
                this.problem.evaluate(child);
                if (this.problem instanceof ConstrainedProblem) {
                    ((ConstrainedProblem)this.problem).evaluateConstraints(child);
                }
                ++this.evaluations;
                this.updateIdealPoint(child);
                this.updateNeighborhood(child, subProblemId, neighborType);
            }
            this.violationThresholdComparator.updateThreshold(this.population);
        } while (this.evaluations < this.maxEvaluations);
    }

    public void initializePopulation() {
        for (int i = 0; i < this.populationSize; ++i) {
            DoubleSolution newSolution = (DoubleSolution)this.problem.createSolution();
            this.problem.evaluate(newSolution);
            if (this.problem instanceof ConstrainedProblem) {
                ((ConstrainedProblem)this.problem).evaluateConstraints(newSolution);
            }
            this.population.add(newSolution);
        }
    }

    @Override
    protected void updateNeighborhood(DoubleSolution individual, int subproblemId, AbstractMOEAD.NeighborType neighborType) {
        int time = 0;
        int size = neighborType == AbstractMOEAD.NeighborType.NEIGHBOR ? this.neighborhood[subproblemId].length : this.population.size();
        int[] perm = new int[size];
        MOEADUtils.randomPermutation(perm, size);
        for (int i = 0; i < size; ++i) {
            int k = neighborType == AbstractMOEAD.NeighborType.NEIGHBOR ? this.neighborhood[subproblemId][perm[i]] : perm[i];
            double f1 = this.fitnessFunction((Solution)this.population.get(k), this.lambda[k]);
            double f2 = this.fitnessFunction(individual, this.lambda[k]);
            if (this.violationThresholdComparator.needToCompare((DoubleSolution)((Solution)this.population.get(k)), individual)) {
                int flag = this.violationThresholdComparator.compare((DoubleSolution)((Solution)this.population.get(k)), individual);
                if (flag == 1) {
                    this.population.set(k, (DoubleSolution)individual.copy());
                } else if (flag == 0 && f2 < f1) {
                    this.population.set(k, (DoubleSolution)individual.copy());
                    ++time;
                }
            } else if (f2 < f1) {
                this.population.set(k, (DoubleSolution)individual.copy());
                ++time;
            }
            if (time < this.maximumNumberOfReplacedSolutions) continue;
            return;
        }
    }

    @Override
    public String getName() {
        return "cMOEAD";
    }

    @Override
    public String getDescription() {
        return "Multi-Objective Evolutionary Algorithm based on Decomposition with constraints support";
    }
}

