/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.moead;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.util.MOEADUtils;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class MOEADD<S extends DoubleSolution>
extends AbstractMOEAD<S> {
    protected Ranking ranking;
    protected int[][] rankIdx;
    protected int[][] subregionIdx;
    protected double[][] subregionDist;
    protected int numRanks;

    public MOEADD(Problem<S> problem, int populationSize, int resultPopulationSize, int maxEvaluations, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutation, AbstractMOEAD.FunctionType functionType, String dataDirectory, double neighborhoodSelectionProbability, int maximumNumberOfReplacedSolutions, int neighborSize) {
        super(problem, populationSize, resultPopulationSize, maxEvaluations, crossoverOperator, mutation, functionType, dataDirectory, neighborhoodSelectionProbability, maximumNumberOfReplacedSolutions, neighborSize);
    }

    @Override
    public void run() {
        this.evaluations = 0;
        this.population = new ArrayList(this.populationSize);
        this.neighborhood = new int[this.populationSize][this.neighborSize];
        this.lambda = new double[this.populationSize][this.problem.getNumberOfObjectives()];
        this.idealPoint = new double[this.problem.getNumberOfObjectives()];
        this.nadirPoint = new double[this.problem.getNumberOfObjectives()];
        this.rankIdx = new int[this.populationSize][this.populationSize];
        this.subregionIdx = new int[this.populationSize][this.populationSize];
        this.subregionDist = new double[this.populationSize][this.populationSize];
        this.initializeUniformWeight();
        this.initializeNeighborhood();
        this.initPopulation();
        this.initializeIdealPoint();
        this.initializeNadirPoint();
        for (int i = 0; i < this.populationSize; ++i) {
            double distance;
            this.subregionDist[i][i] = distance = this.calculateDistance2((DoubleSolution)this.population.get(i), this.lambda[i], this.idealPoint, this.nadirPoint);
        }
        this.ranking = this.computeRanking(this.population);
        for (int curRank = 0; curRank < this.ranking.getNumberOfSubfronts(); ++curRank) {
            List front = this.ranking.getSubfront(curRank);
            for (DoubleSolution s : front) {
                int position = this.population.indexOf(s);
                this.rankIdx[curRank][position] = 1;
            }
        }
        do {
            int[] permutation = new int[this.populationSize];
            MOEADUtils.randomPermutation(permutation, this.populationSize);
            for (int i = 0; i < this.populationSize; ++i) {
                int cid = permutation[i];
                double rnd = this.randomGenerator.nextDouble();
                int type = rnd < this.neighborhoodSelectionProbability ? 1 : 2;
                List<S> parents = this.matingSelection(cid, type);
                List children = (List)this.crossoverOperator.execute(parents);
                DoubleSolution child = (DoubleSolution)children.get(0);
                this.mutationOperator.execute(child);
                this.problem.evaluate(child);
                ++this.evaluations;
                this.updateIdealPoint(child);
                this.updateNadirPoint(child);
                this.updateArchive(child);
            }
        } while (this.evaluations < this.maxEvaluations);
    }

    public void initPopulation() {
        for (int i = 0; i < this.populationSize; ++i) {
            DoubleSolution newSolution = (DoubleSolution)this.problem.createSolution();
            this.problem.evaluate(newSolution);
            ++this.evaluations;
            this.population.add(newSolution);
            this.subregionIdx[i][i] = 1;
        }
    }

    void RefreshNadirPoint() {
        int i;
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            this.nadirPoint[i] = -1.0E30;
        }
        for (i = 0; i < this.populationSize; ++i) {
            this.updateNadirPoint((Solution)this.population.get(i));
        }
    }

    public List<S> matingSelection(int cid, int type) {
        ArrayList parents = new ArrayList(2);
        int nLength = this.neighborhood[cid].length;
        ArrayList<Integer> activeList = new ArrayList<Integer>();
        if (type == 1) {
            int rnd2;
            int i;
            block0: for (i = 0; i < nLength; ++i) {
                int idx = this.neighborhood[cid][i];
                for (int j = 0; j < this.populationSize; ++j) {
                    if (this.subregionIdx[idx][j] != 1) continue;
                    activeList.add(idx);
                    continue block0;
                }
            }
            if (activeList.size() < 2) {
                activeList.clear();
                block2: for (i = 0; i < this.populationSize; ++i) {
                    for (int j = 0; j < this.populationSize; ++j) {
                        if (this.subregionIdx[i][j] != 1) continue;
                        activeList.add(i);
                        continue block2;
                    }
                }
            }
            int activeSize = activeList.size();
            int rnd1 = this.randomGenerator.nextInt(0, activeSize - 1);
            while (rnd1 == (rnd2 = this.randomGenerator.nextInt(0, activeSize - 1))) {
            }
            ArrayList<Integer> list1 = new ArrayList<Integer>();
            ArrayList<Integer> list2 = new ArrayList<Integer>();
            int id1 = (Integer)activeList.get(rnd1);
            int id2 = (Integer)activeList.get(rnd2);
            for (int i2 = 0; i2 < this.populationSize; ++i2) {
                if (this.subregionIdx[id1][i2] == 1) {
                    list1.add(i2);
                }
                if (this.subregionIdx[id2][i2] != 1) continue;
                list2.add(i2);
            }
            int p1 = this.randomGenerator.nextInt(0, list1.size() - 1);
            int p2 = this.randomGenerator.nextInt(0, list2.size() - 1);
            parents.add(this.population.get((Integer)list1.get(p1)));
            parents.add(this.population.get((Integer)list2.get(p2)));
        } else {
            int rnd2;
            block6: for (int i = 0; i < this.populationSize; ++i) {
                for (int j = 0; j < this.populationSize; ++j) {
                    if (this.subregionIdx[i][j] != 1) continue;
                    activeList.add(i);
                    continue block6;
                }
            }
            int activeSize = activeList.size();
            int rnd1 = this.randomGenerator.nextInt(0, activeSize - 1);
            while (rnd1 == (rnd2 = this.randomGenerator.nextInt(0, activeSize - 1))) {
            }
            ArrayList<Integer> list1 = new ArrayList<Integer>();
            ArrayList<Integer> list2 = new ArrayList<Integer>();
            int id1 = (Integer)activeList.get(rnd1);
            int id2 = (Integer)activeList.get(rnd2);
            for (int i = 0; i < this.populationSize; ++i) {
                if (this.subregionIdx[id1][i] == 1) {
                    list1.add(i);
                }
                if (this.subregionIdx[id2][i] != 1) continue;
                list2.add(i);
            }
            int p1 = this.randomGenerator.nextInt(0, list1.size() - 1);
            int p2 = this.randomGenerator.nextInt(0, list2.size() - 1);
            parents.add(this.population.get((Integer)list1.get(p1)));
            parents.add(this.population.get((Integer)list2.get(p2)));
        }
        return parents;
    }

    public void updateArchive(S indiv) {
        this.setLocation(indiv, this.idealPoint, this.nadirPoint);
        int location = (Integer)indiv.getAttribute("region");
        this.numRanks = this.nondominated_sorting_add(indiv);
        if (this.numRanks == 1) {
            this.deleteRankOne(indiv, location);
        } else {
            ArrayList<Object> lastFront = new ArrayList<Object>(this.populationSize);
            int frontSize = this.countRankOnes(this.numRanks - 1);
            if (frontSize == 0) {
                ++frontSize;
                lastFront.add(indiv);
            } else {
                for (int i = 0; i < this.populationSize; ++i) {
                    if (this.rankIdx[this.numRanks - 1][i] != 1) continue;
                    lastFront.add((DoubleSolution)this.population.get(i));
                }
                if ((Integer)indiv.getAttribute(this.ranking.getAttributeIdentifier()) == this.numRanks - 1) {
                    ++frontSize;
                    lastFront.add(indiv);
                }
            }
            if (frontSize == 1 && ((DoubleSolution)lastFront.get(0)).equals(indiv)) {
                int curNC = this.countOnes(location);
                if (curNC > 0) {
                    this.nondominated_sorting_delete(indiv);
                } else {
                    this.deleteCrowdRegion1(indiv, location);
                }
            } else if (frontSize == 1 && !((DoubleSolution)lastFront.get(0)).equals(indiv)) {
                int targetIdx = this.findPosition((DoubleSolution)lastFront.get(0));
                int parentLocation = this.findRegion(targetIdx);
                int curNC = this.countOnes(parentLocation);
                if (parentLocation == location) {
                    ++curNC;
                }
                if (curNC == 1) {
                    this.deleteCrowdRegion2(indiv, location);
                } else {
                    int indivRank = (Integer)indiv.getAttribute(this.ranking.getAttributeIdentifier());
                    int targetRank = (Integer)((DoubleSolution)this.population.get(targetIdx)).getAttribute(this.ranking.getAttributeIdentifier());
                    this.rankIdx[targetRank][targetIdx] = 0;
                    this.rankIdx[indivRank][targetIdx] = 1;
                    DoubleSolution targetSol = (DoubleSolution)this.population.get(targetIdx);
                    this.replace(targetIdx, indiv);
                    this.subregionIdx[parentLocation][targetIdx] = 0;
                    this.subregionIdx[location][targetIdx] = 1;
                    this.nondominated_sorting_delete(targetSol);
                }
            } else {
                int crowdIdx;
                double indivFitness = this.fitnessFunction(indiv, this.lambda[location]);
                int[] idxArray = new int[frontSize];
                int[] regionArray = new int[frontSize];
                for (int i = 0; i < frontSize; ++i) {
                    idxArray[i] = this.findPosition((DoubleSolution)lastFront.get(i));
                    regionArray[i] = idxArray[i] == -1 ? location : this.findRegion(idxArray[i]);
                }
                ArrayList<Integer> crowdList = new ArrayList<Integer>();
                int nicheCount = this.countOnes(regionArray[0]);
                if (regionArray[0] == location) {
                    ++nicheCount;
                }
                crowdList.add(regionArray[0]);
                for (int i = 1; i < frontSize; ++i) {
                    int curSize = this.countOnes(regionArray[i]);
                    if (regionArray[i] == location) {
                        ++curSize;
                    }
                    if (curSize > nicheCount) {
                        crowdList.clear();
                        nicheCount = curSize;
                        crowdList.add(regionArray[i]);
                        continue;
                    }
                    if (curSize != nicheCount) continue;
                    crowdList.add(regionArray[i]);
                }
                if (crowdList.size() == 1) {
                    crowdIdx = (Integer)crowdList.get(0);
                } else {
                    int listLength = crowdList.size();
                    crowdIdx = (Integer)crowdList.get(0);
                    double sumFitness = this.sumFitness(crowdIdx);
                    if (crowdIdx == location) {
                        sumFitness += indivFitness;
                    }
                    for (int i = 1; i < listLength; ++i) {
                        int curIdx = (Integer)crowdList.get(i);
                        double curFitness = this.sumFitness(curIdx);
                        if (curIdx == location) {
                            curFitness += indivFitness;
                        }
                        if (!(curFitness > sumFitness)) continue;
                        crowdIdx = curIdx;
                        sumFitness = curFitness;
                    }
                }
                switch (nicheCount) {
                    case 0: {
                        System.out.println("Impossible empty subregion!!!");
                        break;
                    }
                    case 1: {
                        this.deleteCrowdRegion2(indiv, location);
                        break;
                    }
                    default: {
                        ArrayList<Integer> list = new ArrayList<Integer>();
                        for (int i = 0; i < frontSize; ++i) {
                            if (regionArray[i] != crowdIdx) continue;
                            list.add(i);
                        }
                        if (list.isEmpty()) {
                            System.out.println("Cannot happen!!!");
                            break;
                        }
                        int targetIdx = (Integer)list.get(0);
                        double maxFitness = idxArray[targetIdx] == -1 ? indivFitness : this.fitnessFunction((Solution)this.population.get(idxArray[targetIdx]), this.lambda[crowdIdx]);
                        for (int i = 1; i < list.size(); ++i) {
                            int curIdx = (Integer)list.get(i);
                            double curFitness = idxArray[curIdx] == -1 ? indivFitness : this.fitnessFunction((Solution)this.population.get(idxArray[curIdx]), this.lambda[crowdIdx]);
                            if (!(curFitness > maxFitness)) continue;
                            targetIdx = curIdx;
                            maxFitness = curFitness;
                        }
                        if (idxArray[targetIdx] == -1) {
                            this.nondominated_sorting_delete(indiv);
                            break;
                        }
                        int indivRank = (Integer)indiv.getAttribute(this.ranking.getAttributeIdentifier());
                        int targetRank = (Integer)((DoubleSolution)this.population.get(idxArray[targetIdx])).getAttribute(this.ranking.getAttributeIdentifier());
                        this.rankIdx[targetRank][idxArray[targetIdx]] = 0;
                        this.rankIdx[indivRank][idxArray[targetIdx]] = 1;
                        DoubleSolution targetSol = (DoubleSolution)this.population.get(idxArray[targetIdx]);
                        this.replace(idxArray[targetIdx], indiv);
                        this.subregionIdx[crowdIdx][idxArray[targetIdx]] = 0;
                        this.subregionIdx[location][idxArray[targetIdx]] = 1;
                        this.nondominated_sorting_delete(targetSol);
                    }
                }
            }
        }
    }

    public void nondominated_sorting_delete(S indiv) {
        boolean flag;
        int indivRank = (Integer)indiv.getAttribute(this.ranking.getAttributeIdentifier());
        ArrayList<Integer> curLevel = new ArrayList<Integer>();
        ArrayList<Integer> dominateList = new ArrayList<Integer>();
        for (int i = 0; i < this.populationSize; ++i) {
            if (this.rankIdx[indivRank][i] != 1) continue;
            curLevel.add(i);
        }
        int investigateRank = indivRank + 1;
        if (investigateRank < this.numRanks) {
            for (int i = 0; i < this.populationSize; ++i) {
                if (this.rankIdx[investigateRank][i] != 1) continue;
                flag = false;
                if (this.checkDominance(indiv, (DoubleSolution)this.population.get(i)) != 1) continue;
                for (int j = 0; j < curLevel.size(); ++j) {
                    if (this.checkDominance((DoubleSolution)this.population.get(i), (DoubleSolution)this.population.get((Integer)curLevel.get(j))) != -1) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                dominateList.add(i);
                this.rankIdx[investigateRank][i] = 0;
                this.rankIdx[investigateRank - 1][i] = 1;
                ((DoubleSolution)this.population.get(i)).setAttribute(this.ranking.getAttributeIdentifier(), investigateRank - 1);
            }
        }
        int curListSize = dominateList.size();
        while (curListSize != 0) {
            int i;
            curLevel.clear();
            for (i = 0; i < this.populationSize; ++i) {
                if (this.rankIdx[investigateRank][i] != 1) continue;
                curLevel.add(i);
            }
            if (++investigateRank < this.numRanks) {
                for (i = 0; i < curListSize; ++i) {
                    int curIdx = (Integer)dominateList.get(i);
                    for (int j = 0; j < this.populationSize; ++j) {
                        if (j == this.populationSize) {
                            System.err.println("There are problems");
                        }
                        if (this.rankIdx[investigateRank][j] != 1) continue;
                        flag = false;
                        if (this.checkDominance((DoubleSolution)this.population.get(curIdx), (DoubleSolution)this.population.get(j)) != 1) continue;
                        for (int k = 0; k < curLevel.size(); ++k) {
                            if (this.checkDominance((DoubleSolution)this.population.get(j), (DoubleSolution)this.population.get((Integer)curLevel.get(k))) != -1) continue;
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        dominateList.add(j);
                        this.rankIdx[investigateRank][j] = 0;
                        this.rankIdx[investigateRank - 1][j] = 1;
                        ((DoubleSolution)this.population.get(j)).setAttribute(this.ranking.getAttributeIdentifier(), investigateRank - 1);
                    }
                }
            }
            for (i = 0; i < curListSize; ++i) {
                dominateList.remove(0);
            }
            curListSize = dominateList.size();
        }
    }

    public int nondominated_sorting_add(S indiv) {
        int rankCount;
        int flag = 0;
        int num_ranks = 0;
        ArrayList<Integer> frontSize = new ArrayList<Integer>();
        for (int i = 0; i < this.populationSize && (rankCount = this.countRankOnes(i)) != 0; ++i) {
            frontSize.add(rankCount);
            ++num_ranks;
        }
        ArrayList<Integer> dominateList = new ArrayList<Integer>();
        int level = 0;
        block11: for (int i = 0; i < num_ranks; ++i) {
            level = i;
            if (flag == 1) {
                indiv.setAttribute(this.ranking.getAttributeIdentifier(), i - 1);
                return num_ranks;
            }
            if (flag == 2) {
                int curIdx;
                int j;
                indiv.setAttribute(this.ranking.getAttributeIdentifier(), i - 1);
                int prevRank = i - 1;
                int newRank = prevRank + 1;
                int curListSize = dominateList.size();
                for (j = 0; j < curListSize; ++j) {
                    curIdx = (Integer)dominateList.get(j);
                    this.rankIdx[prevRank][curIdx] = 0;
                    this.rankIdx[newRank][curIdx] = 1;
                    ((DoubleSolution)this.population.get(curIdx)).setAttribute(this.ranking.getAttributeIdentifier(), newRank);
                }
                block13: for (j = 0; j < this.populationSize; ++j) {
                    if (this.rankIdx[newRank][j] != 1) continue;
                    for (int k = 0; k < curListSize; ++k) {
                        curIdx = (Integer)dominateList.get(k);
                        if (this.checkDominance((DoubleSolution)this.population.get(curIdx), (DoubleSolution)this.population.get(j)) != 1) continue;
                        dominateList.add(j);
                        continue block13;
                    }
                }
                for (j = 0; j < curListSize; ++j) {
                    dominateList.remove(0);
                }
                prevRank = newRank++;
                curListSize = dominateList.size();
                if (curListSize == 0) {
                    return num_ranks;
                }
                boolean allFlag = false;
                do {
                    int j2;
                    for (j2 = 0; j2 < curListSize; ++j2) {
                        curIdx = (Integer)dominateList.get(j2);
                        this.rankIdx[prevRank][curIdx] = 0;
                        this.rankIdx[newRank][curIdx] = 1;
                        ((DoubleSolution)this.population.get(curIdx)).setAttribute(this.ranking.getAttributeIdentifier(), newRank);
                    }
                    block18: for (j2 = 0; j2 < this.populationSize; ++j2) {
                        if (this.rankIdx[newRank][j2] != 1) continue;
                        for (int k = 0; k < curListSize; ++k) {
                            curIdx = (Integer)dominateList.get(k);
                            if (this.checkDominance((DoubleSolution)this.population.get(curIdx), (DoubleSolution)this.population.get(j2)) != 1) continue;
                            dominateList.add(j2);
                            continue block18;
                        }
                    }
                    for (j2 = 0; j2 < curListSize; ++j2) {
                        dominateList.remove(0);
                    }
                    curListSize = dominateList.size();
                    if (curListSize == 0) continue;
                    prevRank = newRank++;
                    if (frontSize.size() <= prevRank || curListSize != (Integer)frontSize.get(prevRank)) continue;
                    allFlag = true;
                    break;
                } while (curListSize != 0);
                if (allFlag) {
                    int remainSize = num_ranks - prevRank;
                    int[][] tempRecord = new int[remainSize][this.populationSize];
                    int tempIdx = 0;
                    for (int j3 = 0; j3 < dominateList.size(); ++j3) {
                        tempRecord[0][tempIdx] = (Integer)dominateList.get(j3);
                        ++tempIdx;
                    }
                    int k = 1;
                    int curRank = prevRank + 1;
                    while (curRank < num_ranks) {
                        tempIdx = 0;
                        for (int j4 = 0; j4 < this.populationSize; ++j4) {
                            if (this.rankIdx[curRank][j4] != 1) continue;
                            tempRecord[k][tempIdx] = j4;
                            ++tempIdx;
                        }
                        ++curRank;
                        ++k;
                    }
                    k = 0;
                    curRank = prevRank;
                    while (curRank < num_ranks) {
                        int level_size = (Integer)frontSize.get(curRank);
                        for (int j5 = 0; j5 < level_size; ++j5) {
                            curIdx = tempRecord[k][j5];
                            int tempRank = (Integer)((DoubleSolution)this.population.get(curIdx)).getAttribute(this.ranking.getAttributeIdentifier());
                            newRank = tempRank + 1;
                            ((DoubleSolution)this.population.get(curIdx)).setAttribute(this.ranking.getAttributeIdentifier(), newRank);
                            this.rankIdx[tempRank][curIdx] = 0;
                            this.rankIdx[newRank][curIdx] = 1;
                        }
                        ++curRank;
                        ++k;
                    }
                    ++num_ranks;
                }
                if (newRank == num_ranks) {
                    ++num_ranks;
                }
                return num_ranks;
            }
            if (flag == 3 || flag == 0) {
                boolean flag3 = false;
                boolean flag2 = false;
                boolean flag1 = false;
                for (int j = 0; j < this.populationSize; ++j) {
                    if (this.rankIdx[i][j] != 1) continue;
                    switch (this.checkDominance(indiv, (DoubleSolution)this.population.get(j))) {
                        case 1: {
                            flag1 = true;
                            dominateList.add(j);
                            break;
                        }
                        case 0: {
                            flag2 = true;
                            break;
                        }
                        case -1: {
                            flag3 = true;
                        }
                    }
                    if (flag3) {
                        flag = 3;
                        continue block11;
                    }
                    if (!flag1 && flag2) {
                        flag = 1;
                        continue;
                    }
                    if (flag1 && flag2) {
                        flag = 2;
                        continue;
                    }
                    if (!flag1 || flag2) continue;
                    flag = 4;
                }
                continue;
            }
            indiv.setAttribute(this.ranking.getAttributeIdentifier(), i - 1);
            int remainSize = num_ranks - --i;
            int[][] tempRecord = new int[remainSize][this.populationSize];
            int k = 0;
            while (i < num_ranks) {
                int tempIdx = 0;
                for (int j = 0; j < this.populationSize; ++j) {
                    if (this.rankIdx[i][j] != 1) continue;
                    tempRecord[k][tempIdx] = j;
                    ++tempIdx;
                }
                ++i;
                ++k;
            }
            k = 0;
            i = (Integer)indiv.getAttribute(this.ranking.getAttributeIdentifier());
            while (i < num_ranks) {
                int level_size = (Integer)frontSize.get(i);
                for (int j = 0; j < level_size; ++j) {
                    int curIdx = tempRecord[k][j];
                    int curRank = (Integer)((DoubleSolution)this.population.get(curIdx)).getAttribute(this.ranking.getAttributeIdentifier());
                    int newRank = curRank + 1;
                    ((DoubleSolution)this.population.get(curIdx)).setAttribute(this.ranking.getAttributeIdentifier(), newRank);
                    this.rankIdx[curRank][curIdx] = 0;
                    this.rankIdx[newRank][curIdx] = 1;
                }
                ++i;
                ++k;
            }
            return ++num_ranks;
        }
        switch (flag) {
            case 1: {
                indiv.setAttribute(this.ranking.getAttributeIdentifier(), level);
                break;
            }
            case 2: {
                indiv.setAttribute(this.ranking.getAttributeIdentifier(), level);
                int tempSize = dominateList.size();
                for (int i = 0; i < tempSize; ++i) {
                    int curIdx = (Integer)dominateList.get(i);
                    ((DoubleSolution)this.population.get(curIdx)).setAttribute(this.ranking.getAttributeIdentifier(), level + 1);
                    this.rankIdx[level][curIdx] = 0;
                    this.rankIdx[level + 1][curIdx] = 1;
                }
                ++num_ranks;
                break;
            }
            case 3: {
                indiv.setAttribute(this.ranking.getAttributeIdentifier(), level + 1);
                ++num_ranks;
                break;
            }
            default: {
                indiv.setAttribute(this.ranking.getAttributeIdentifier(), level);
                for (int i = 0; i < this.populationSize; ++i) {
                    if (this.rankIdx[level][i] != 1) continue;
                    ((DoubleSolution)this.population.get(i)).setAttribute(this.ranking.getAttributeIdentifier(), level + 1);
                    this.rankIdx[level][i] = 0;
                    this.rankIdx[level + 1][i] = 1;
                }
                ++num_ranks;
            }
        }
        return num_ranks;
    }

    public void deleteCrowdRegion1(S indiv, int location) {
        int i;
        int crowdIdx;
        ArrayList<Integer> crowdList = new ArrayList<Integer>();
        int nicheCount = this.countOnes(0);
        crowdList.add(0);
        for (int i2 = 1; i2 < this.populationSize; ++i2) {
            int curSize = this.countOnes(i2);
            if (curSize > nicheCount) {
                crowdList.clear();
                nicheCount = curSize;
                crowdList.add(i2);
                continue;
            }
            if (curSize != nicheCount) continue;
            crowdList.add(i2);
        }
        if (crowdList.size() == 1) {
            crowdIdx = (Integer)crowdList.get(0);
        } else {
            int listLength = crowdList.size();
            crowdIdx = (Integer)crowdList.get(0);
            double sumFitness = this.sumFitness(crowdIdx);
            for (i = 1; i < listLength; ++i) {
                int curIdx = (Integer)crowdList.get(i);
                double curFitness = this.sumFitness(curIdx);
                if (!(curFitness > sumFitness)) continue;
                crowdIdx = curIdx;
                sumFitness = curFitness;
            }
        }
        ArrayList<Integer> indList = new ArrayList<Integer>();
        for (int i3 = 0; i3 < this.populationSize; ++i3) {
            if (this.subregionIdx[crowdIdx][i3] != 1) continue;
            indList.add(i3);
        }
        ArrayList maxRankList = new ArrayList();
        int maxRank = (Integer)((DoubleSolution)this.population.get((Integer)indList.get(0))).getAttribute(this.ranking.getAttributeIdentifier());
        maxRankList.add(indList.get(0));
        for (i = 1; i < indList.size(); ++i) {
            int curRank = (Integer)((DoubleSolution)this.population.get((Integer)indList.get(i))).getAttribute(this.ranking.getAttributeIdentifier());
            if (curRank > maxRank) {
                maxRankList.clear();
                maxRank = curRank;
                maxRankList.add(indList.get(i));
                continue;
            }
            if (curRank != maxRank) continue;
            maxRankList.add(indList.get(i));
        }
        int rankSize = maxRankList.size();
        int targetIdx = (Integer)maxRankList.get(0);
        double maxFitness = this.fitnessFunction((Solution)this.population.get(targetIdx), this.lambda[crowdIdx]);
        for (int i4 = 1; i4 < rankSize; ++i4) {
            int curIdx = (Integer)maxRankList.get(i4);
            double curFitness = this.fitnessFunction((Solution)this.population.get(curIdx), this.lambda[crowdIdx]);
            if (!(curFitness > maxFitness)) continue;
            targetIdx = curIdx;
            maxFitness = curFitness;
        }
        int indivRank = (Integer)indiv.getAttribute(this.ranking.getAttributeIdentifier());
        int targetRank = (Integer)((DoubleSolution)this.population.get(targetIdx)).getAttribute(this.ranking.getAttributeIdentifier());
        this.rankIdx[targetRank][targetIdx] = 0;
        this.rankIdx[indivRank][targetIdx] = 1;
        DoubleSolution targetSol = (DoubleSolution)this.population.get(targetIdx);
        this.replace(targetIdx, indiv);
        this.subregionIdx[crowdIdx][targetIdx] = 0;
        this.subregionIdx[location][targetIdx] = 1;
        this.nondominated_sorting_delete(targetSol);
    }

    public void deleteCrowdRegion2(S indiv, int location) {
        int i;
        int crowdIdx;
        double indivFitness = this.fitnessFunction(indiv, this.lambda[location]);
        ArrayList<Integer> crowdList = new ArrayList<Integer>();
        int nicheCount = this.countOnes(0);
        if (location == 0) {
            ++nicheCount;
        }
        crowdList.add(0);
        for (int i2 = 1; i2 < this.populationSize; ++i2) {
            int curSize = this.countOnes(i2);
            if (location == i2) {
                ++curSize;
            }
            if (curSize > nicheCount) {
                crowdList.clear();
                nicheCount = curSize;
                crowdList.add(i2);
                continue;
            }
            if (curSize != nicheCount) continue;
            crowdList.add(i2);
        }
        if (crowdList.size() == 1) {
            crowdIdx = (Integer)crowdList.get(0);
        } else {
            int listLength = crowdList.size();
            crowdIdx = (Integer)crowdList.get(0);
            double sumFitness = this.sumFitness(crowdIdx);
            if (crowdIdx == location) {
                sumFitness += indivFitness;
            }
            for (i = 1; i < listLength; ++i) {
                int curIdx = (Integer)crowdList.get(i);
                double curFitness = this.sumFitness(curIdx);
                if (curIdx == location) {
                    curFitness += indivFitness;
                }
                if (!(curFitness > sumFitness)) continue;
                crowdIdx = curIdx;
                sumFitness = curFitness;
            }
        }
        ArrayList<Integer> indList = new ArrayList<Integer>();
        for (int i3 = 0; i3 < this.populationSize; ++i3) {
            if (this.subregionIdx[crowdIdx][i3] != 1) continue;
            indList.add(i3);
        }
        if (crowdIdx == location) {
            int temp = -1;
            indList.add(temp);
        }
        ArrayList maxRankList = new ArrayList();
        int maxRank = (Integer)((DoubleSolution)this.population.get((Integer)indList.get(0))).getAttribute(this.ranking.getAttributeIdentifier());
        maxRankList.add(indList.get(0));
        for (i = 1; i < indList.size(); ++i) {
            int curRank = (Integer)indList.get(i) == -1 ? ((Integer)indiv.getAttribute(this.ranking.getAttributeIdentifier())).intValue() : ((Integer)((DoubleSolution)this.population.get((Integer)indList.get(i))).getAttribute(this.ranking.getAttributeIdentifier())).intValue();
            if (curRank > maxRank) {
                maxRankList.clear();
                maxRank = curRank;
                maxRankList.add(indList.get(i));
                continue;
            }
            if (curRank != maxRank) continue;
            maxRankList.add(indList.get(i));
        }
        int rankSize = maxRankList.size();
        int targetIdx = (Integer)maxRankList.get(0);
        double maxFitness = targetIdx == -1 ? indivFitness : this.fitnessFunction((Solution)this.population.get(targetIdx), this.lambda[crowdIdx]);
        for (int i4 = 1; i4 < rankSize; ++i4) {
            int curIdx = (Integer)maxRankList.get(i4);
            double curFitness = curIdx == -1 ? indivFitness : this.fitnessFunction((Solution)this.population.get(curIdx), this.lambda[crowdIdx]);
            if (!(curFitness > maxFitness)) continue;
            targetIdx = curIdx;
            maxFitness = curFitness;
        }
        if (targetIdx == -1) {
            this.nondominated_sorting_delete(indiv);
        } else {
            int indivRank = (Integer)indiv.getAttribute(this.ranking.getAttributeIdentifier());
            int targetRank = (Integer)((DoubleSolution)this.population.get(targetIdx)).getAttribute(this.ranking.getAttributeIdentifier());
            this.rankIdx[targetRank][targetIdx] = 0;
            this.rankIdx[indivRank][targetIdx] = 1;
            DoubleSolution targetSol = (DoubleSolution)this.population.get(targetIdx);
            this.replace(targetIdx, indiv);
            this.subregionIdx[crowdIdx][targetIdx] = 0;
            this.subregionIdx[location][targetIdx] = 1;
            this.nondominated_sorting_delete(targetSol);
        }
    }

    public void deleteRankOne(S indiv, int location) {
        int crowdIdx;
        double indivFitness = this.fitnessFunction(indiv, this.lambda[location]);
        ArrayList<Integer> crowdList = new ArrayList<Integer>();
        int nicheCount = this.countOnes(0);
        if (location == 0) {
            ++nicheCount;
        }
        crowdList.add(0);
        for (int i = 1; i < this.populationSize; ++i) {
            int curSize = this.countOnes(i);
            if (location == i) {
                ++curSize;
            }
            if (curSize > nicheCount) {
                crowdList.clear();
                nicheCount = curSize;
                crowdList.add(i);
                continue;
            }
            if (curSize != nicheCount) continue;
            crowdList.add(i);
        }
        if (crowdList.size() == 1) {
            crowdIdx = (Integer)crowdList.get(0);
        } else {
            int listLength = crowdList.size();
            crowdIdx = (Integer)crowdList.get(0);
            double sumFitness = this.sumFitness(crowdIdx);
            if (crowdIdx == location) {
                sumFitness += indivFitness;
            }
            for (int i = 1; i < listLength; ++i) {
                int curIdx = (Integer)crowdList.get(i);
                double curFitness = this.sumFitness(curIdx);
                if (curIdx == location) {
                    curFitness += indivFitness;
                }
                if (!(curFitness > sumFitness)) continue;
                crowdIdx = curIdx;
                sumFitness = curFitness;
            }
        }
        switch (nicheCount) {
            case 0: {
                System.out.println("Empty subregion!!!");
                break;
            }
            case 1: {
                int targetIdx;
                for (targetIdx = 0; targetIdx < this.populationSize && this.subregionIdx[location][targetIdx] != 1; ++targetIdx) {
                }
                double prev_func = this.fitnessFunction((Solution)this.population.get(targetIdx), this.lambda[location]);
                if (!(indivFitness < prev_func)) break;
                this.replace(targetIdx, indiv);
                break;
            }
            default: {
                if (location == crowdIdx) {
                    this.deleteCrowdIndiv_same(location, nicheCount, indivFitness, indiv);
                    break;
                }
                int curNC = this.countOnes(location);
                int crowdNC = this.countOnes(crowdIdx);
                if (crowdNC > curNC + 1) {
                    this.deleteCrowdIndiv_diff(crowdIdx, location, crowdNC, indiv);
                    break;
                }
                if (crowdNC < curNC + 1) {
                    this.deleteCrowdIndiv_same(location, curNC, indivFitness, indiv);
                    break;
                }
                if (curNC == 0) {
                    this.deleteCrowdIndiv_diff(crowdIdx, location, crowdNC, indiv);
                    break;
                }
                double rnd = this.randomGenerator.nextDouble();
                if (rnd < 0.5) {
                    this.deleteCrowdIndiv_diff(crowdIdx, location, crowdNC, indiv);
                    break;
                }
                this.deleteCrowdIndiv_same(location, curNC, indivFitness, indiv);
            }
        }
    }

    public double sumFitness(int location) {
        double sum = 0.0;
        for (int i = 0; i < this.populationSize; ++i) {
            if (this.subregionIdx[location][i] != 1) continue;
            sum += this.fitnessFunction((Solution)this.population.get(i), this.lambda[location]);
        }
        return sum;
    }

    public void deleteCrowdIndiv_same(int crowdIdx, int nicheCount, double indivFitness, S indiv) {
        ArrayList<Integer> indList = new ArrayList<Integer>();
        for (int i = 0; i < this.populationSize; ++i) {
            if (this.subregionIdx[crowdIdx][i] != 1) continue;
            indList.add(i);
        }
        int listSize = indList.size();
        int worstIdx = (Integer)indList.get(0);
        double maxFitness = this.fitnessFunction((Solution)this.population.get(worstIdx), this.lambda[crowdIdx]);
        for (int i = 1; i < listSize; ++i) {
            int curIdx = (Integer)indList.get(i);
            double curFitness = this.fitnessFunction((Solution)this.population.get(curIdx), this.lambda[crowdIdx]);
            if (!(curFitness > maxFitness)) continue;
            worstIdx = curIdx;
            maxFitness = curFitness;
        }
        if (indivFitness < maxFitness) {
            this.replace(worstIdx, indiv);
        }
    }

    public void deleteCrowdIndiv_diff(int crowdIdx, int curLocation, int nicheCount, S indiv) {
        ArrayList<Integer> indList = new ArrayList<Integer>();
        for (int i = 0; i < this.populationSize; ++i) {
            if (this.subregionIdx[crowdIdx][i] != 1) continue;
            indList.add(i);
        }
        int worstIdx = (Integer)indList.get(0);
        double maxFitness = this.fitnessFunction((Solution)this.population.get(worstIdx), this.lambda[crowdIdx]);
        for (int i = 1; i < nicheCount; ++i) {
            int curIdx = (Integer)indList.get(i);
            double curFitness = this.fitnessFunction((Solution)this.population.get(curIdx), this.lambda[crowdIdx]);
            if (!(curFitness > maxFitness)) continue;
            worstIdx = curIdx;
            maxFitness = curFitness;
        }
        this.replace(worstIdx, indiv);
        this.subregionIdx[crowdIdx][worstIdx] = 0;
        this.subregionIdx[curLocation][worstIdx] = 1;
    }

    public int countOnes(int location) {
        int count = 0;
        for (int i = 0; i < this.populationSize; ++i) {
            if (this.subregionIdx[location][i] != 1) continue;
            ++count;
        }
        return count;
    }

    public int countRankOnes(int location) {
        int count = 0;
        for (int i = 0; i < this.populationSize; ++i) {
            if (this.rankIdx[location][i] != 1) continue;
            ++count;
        }
        return count;
    }

    public int findPosition(S indiv) {
        for (int i = 0; i < this.populationSize; ++i) {
            if (!indiv.equals(this.population.get(i))) continue;
            return i;
        }
        return -1;
    }

    public int findRegion(int idx) {
        for (int i = 0; i < this.populationSize; ++i) {
            if (this.subregionIdx[i][idx] != 1) continue;
            return i;
        }
        return -1;
    }

    public void setLocation(S indiv, double[] z_, double[] nz_) {
        double distance;
        int minIdx = 0;
        double minDist = distance = this.calculateDistance2(indiv, this.lambda[0], z_, nz_);
        for (int i = 1; i < this.populationSize; ++i) {
            distance = this.calculateDistance2(indiv, this.lambda[i], z_, nz_);
            if (!(distance < minDist)) continue;
            minIdx = i;
            minDist = distance;
        }
        indiv.setAttribute("region", minIdx);
    }

    public int checkDominance(S a2, S b) {
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            if (a2.getObjective(i) < b.getObjective(i)) {
                flag1 = true;
                continue;
            }
            if (!(a2.getObjective(i) > b.getObjective(i))) continue;
            flag2 = true;
        }
        if (flag1 && !flag2) {
            return 1;
        }
        if (!flag1 && flag2) {
            return -1;
        }
        return 0;
    }

    public double calculateDistance(S individual, double[] lambda, double[] z_, double[] nz_) {
        int i;
        double[] vecInd = new double[this.problem.getNumberOfObjectives()];
        double[] vecProj = new double[this.problem.getNumberOfObjectives()];
        double nd = this.norm_vector(lambda);
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            lambda[i] = lambda[i] / nd;
        }
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            vecInd[i] = (individual.getObjective(i) - z_[i]) / (nz_[i] - z_[i]);
        }
        double scale = this.innerproduct(vecInd, lambda);
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            vecProj[i] = vecInd[i] - scale * lambda[i];
        }
        double distance = this.norm_vector(vecProj);
        return distance;
    }

    public double calculateDistance2(S indiv, double[] lambda, double[] z_, double[] nz_) {
        double nd = this.norm_vector(lambda);
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            lambda[i] = lambda[i] / nd;
        }
        double[] realA = new double[this.problem.getNumberOfObjectives()];
        double[] realB = new double[this.problem.getNumberOfObjectives()];
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            realA[i] = indiv.getObjective(i) - z_[i];
        }
        double d1 = Math.abs(this.innerproduct(realA, lambda));
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            realB[i] = indiv.getObjective(i) - (z_[i] + d1 * lambda[i]);
        }
        double distance = this.norm_vector(realB);
        return distance;
    }

    public double innerproduct(double[] vec1, double[] vec2) {
        double sum = 0.0;
        for (int i = 0; i < vec1.length; ++i) {
            sum += vec1[i] * vec2[i];
        }
        return sum;
    }

    public double norm_vector(double[] z) {
        double sum = 0.0;
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            sum += z[i] * z[i];
        }
        return Math.sqrt(sum);
    }

    public int countTest() {
        int sum = 0;
        for (int i = 0; i < this.populationSize; ++i) {
            for (int j = 0; j < this.populationSize; ++j) {
                if (this.subregionIdx[i][j] != 1) continue;
                ++sum;
            }
        }
        return sum;
    }

    @Override
    public String getName() {
        return "MOEADD";
    }

    @Override
    public String getDescription() {
        return "An Evolutionary Many-Objective Optimization Algorithm Based on Dominance and Decomposition";
    }

    public void replace(int position, S solution) {
        if (position > this.population.size()) {
            this.population.add(solution);
        } else {
            DoubleSolution toRemove = (DoubleSolution)this.population.get(position);
            this.population.remove(toRemove);
            this.population.add(position, solution);
        }
    }

    protected Ranking<S> computeRanking(List<S> solutionList) {
        DominanceRanking<S> ranking = new DominanceRanking<S>();
        ranking.computeRanking(solutionList);
        return ranking;
    }
}

