/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.moead.util;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.distance.impl.EuclideanDistanceBetweenSolutionAndASolutionListInObjectiveSpace;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.referencePoint.impl.IdealPoint;

public class MOEADUtils {
    public static void quickSort(double[] array, int[] idx, int from, int to) {
        if (from < to) {
            double temp = array[to];
            int tempIdx = idx[to];
            int i = from - 1;
            for (int j = from; j < to; ++j) {
                if (!(array[j] <= temp)) continue;
                double tempValue = array[j];
                array[j] = array[++i];
                array[i] = tempValue;
                int tempIndex = idx[j];
                idx[j] = idx[i];
                idx[i] = tempIndex;
            }
            array[to] = array[i + 1];
            array[i + 1] = temp;
            idx[to] = idx[i + 1];
            idx[i + 1] = tempIdx;
            MOEADUtils.quickSort(array, idx, from, i);
            MOEADUtils.quickSort(array, idx, i + 1, to);
        }
    }

    public static double distVector(double[] vector1, double[] vector2) {
        int dim = vector1.length;
        double sum = 0.0;
        for (int n = 0; n < dim; ++n) {
            sum += (vector1[n] - vector2[n]) * (vector1[n] - vector2[n]);
        }
        return Math.sqrt(sum);
    }

    public static void minFastSort(double[] x, int[] idx, int n, int m) {
        for (int i = 0; i < m; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!(x[i] > x[j])) continue;
                double temp = x[i];
                x[i] = x[j];
                x[j] = temp;
                int id = idx[i];
                idx[i] = idx[j];
                idx[j] = id;
            }
        }
    }

    public static void randomPermutation(int[] perm, int size) {
        JMetalRandom randomGenerator = JMetalRandom.getInstance();
        int[] index = new int[size];
        boolean[] flag = new boolean[size];
        for (int n = 0; n < size; ++n) {
            index[n] = n;
            flag[n] = true;
        }
        block1: for (int num = 0; num < size; ++num) {
            int start = randomGenerator.nextInt(0, size - 1);
            while (true) {
                if (flag[start]) {
                    perm[num] = index[start];
                    flag[start] = false;
                    continue block1;
                }
                if (start == size - 1) {
                    start = 0;
                    continue;
                }
                ++start;
            }
        }
    }

    public static <S extends Solution<?>> List<S> getSubsetOfEvenlyDistributedSolutions(List<S> solutionList, int newSolutionListSize) {
        ArrayList resultSolutionList = new ArrayList(newSolutionListSize);
        if (solutionList == null) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.size() > 0) {
            int numberOfObjectives = ((Solution)solutionList.get(0)).getNumberOfObjectives();
            if (numberOfObjectives == 2) {
                MOEADUtils.twoObjectivesCase(solutionList, resultSolutionList, newSolutionListSize);
            } else {
                MOEADUtils.moreThanTwoObjectivesCase(solutionList, resultSolutionList, newSolutionListSize);
            }
        }
        return resultSolutionList;
    }

    private static <S extends Solution<?>> void twoObjectivesCase(List<S> solutionList, List<S> resultSolutionList, int newSolutionListSize) {
        double[][] lambda = new double[newSolutionListSize][2];
        for (int i = 0; i < newSolutionListSize; ++i) {
            double a2;
            lambda[i][0] = a2 = 1.0 * (double)i / (double)(newSolutionListSize - 1);
            lambda[i][1] = 1.0 - a2;
        }
        IdealPoint idealPoint = new IdealPoint(2);
        solutionList.stream().forEach(solution -> idealPoint.update((Solution<?>)solution));
        for (int v = 0; v < idealPoint.getNumberOfObjectives(); ++v) {
            System.out.println(idealPoint.getObjective(v));
        }
        for (int i = 0; i < newSolutionListSize; ++i) {
            Solution currentBest = (Solution)solutionList.get(0);
            double value = MOEADUtils.scalarizingFitnessFunction(currentBest, lambda[i], idealPoint);
            for (int j = 1; j < solutionList.size(); ++j) {
                double aux = MOEADUtils.scalarizingFitnessFunction((Solution)solutionList.get(j), lambda[i], idealPoint);
                if (!(aux < value)) continue;
                value = aux;
                currentBest = (Solution)solutionList.get(j);
            }
            resultSolutionList.add(currentBest.copy());
        }
    }

    private static <S extends Solution<?>> void moreThanTwoObjectivesCase(List<S> solutionList, List<S> resultSolutionList, int newSolutionListSize) {
        EuclideanDistanceBetweenSolutionAndASolutionListInObjectiveSpace distance = new EuclideanDistanceBetweenSolutionAndASolutionListInObjectiveSpace();
        int randomIndex = JMetalRandom.getInstance().nextInt(0, solutionList.size() - 1);
        ArrayList<S> candidate = new ArrayList<S>();
        resultSolutionList.add(solutionList.get(randomIndex));
        for (int i = 0; i < solutionList.size(); ++i) {
            if (i == randomIndex) continue;
            candidate.add(solutionList.get(i));
        }
        while (resultSolutionList.size() < newSolutionListSize) {
            int index = 0;
            Solution selected = (Solution)candidate.get(0);
            double aux = distance.getDistance(selected, solutionList);
            for (int i = 1; i < candidate.size(); ++i) {
                Solution nextCandidate = (Solution)candidate.get(i);
                double distanceValue = distance.getDistance(nextCandidate, solutionList);
                if (!(aux < distanceValue)) continue;
                index = i;
                aux = distanceValue;
            }
            Solution removedSolution = (Solution)candidate.remove(index);
            resultSolutionList.add(removedSolution.copy());
        }
    }

    private static <S extends Solution<?>> double scalarizingFitnessFunction(S currentBest, double[] lambda, IdealPoint idealPoint) {
        double maxFun = -1.0E30;
        for (int n = 0; n < idealPoint.getNumberOfObjectives(); ++n) {
            double diff = Math.abs(currentBest.getObjective(n) - idealPoint.getObjective(n));
            double functionValue = lambda[n] == 0.0 ? 1.0E-4 * diff : diff * lambda[n];
            if (!(functionValue > maxFun)) continue;
            maxFun = functionValue;
        }
        return maxFun;
    }
}

