/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mombi.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.solution.Solution;

public class MOMBI2History<T extends Solution<?>>
implements Serializable {
    public static final int MAX_LENGHT = 5;
    private final int numberOfObjectives;
    private final List<List<Double>> history;
    private final List<Integer> marks;

    public MOMBI2History(int numberOfObjectives) {
        this.numberOfObjectives = numberOfObjectives;
        this.history = new LinkedList<List<Double>>();
        this.marks = new ArrayList<Integer>(this.numberOfObjectives);
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            this.marks.add(5);
        }
    }

    public void add(List<Double> maxs) {
        ArrayList<Double> aux = new ArrayList<Double>(this.numberOfObjectives);
        aux.addAll(maxs);
        this.history.add(aux);
        if (this.history.size() > 5) {
            this.history.remove(0);
        }
    }

    public List<Double> mean() {
        ArrayList<Double> result = new ArrayList<Double>(this.numberOfObjectives);
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            result.add(0.0);
        }
        for (List<Double> historyMember : this.history) {
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                result.set(i, (Double)result.get(i) + historyMember.get(i));
            }
        }
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            result.set(i, (Double)result.get(i) / (double)this.history.size());
        }
        return result;
    }

    public List<Double> variance(List<Double> mean) {
        ArrayList<Double> result = new ArrayList<Double>(this.numberOfObjectives);
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            result.add(0.0);
        }
        for (List<Double> historyMember : this.history) {
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                result.set(i, (Double)result.get(i) + Math.pow(historyMember.get(i) - mean.get(i), 2.0));
            }
        }
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            result.set(i, (Double)result.get(i) / (double)this.history.size());
        }
        return result;
    }

    public List<Double> std(List<Double> mean) {
        ArrayList<Double> result = new ArrayList<Double>(mean.size());
        result.addAll(this.variance(mean));
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, Math.sqrt((Double)result.get(i)));
        }
        return result;
    }

    public void mark(int index) {
        this.marks.set(index, 5);
    }

    public boolean isUnMarked(int index) {
        return this.marks.get(index) == 0;
    }

    public void decreaseMark(int index) {
        if (this.marks.get(index) > 0) {
            this.marks.set(index, this.marks.get(index) - 1);
        }
    }

    public Double getMaxObjective(int index) {
        Double result = Double.NEGATIVE_INFINITY;
        for (List<Double> list : this.history) {
            result = Math.max(result, list.get(index));
        }
        return result;
    }
}

