/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaiii;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.uma.jmetal.algorithm.impl.AbstractGeneticAlgorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaiii.NSGAIIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaiii.util.EnvironmentalSelection;
import org.uma.jmetal.algorithm.multiobjective.nsgaiii.util.ReferencePoint;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class NSGAIII<S extends Solution<?>>
extends AbstractGeneticAlgorithm<S, List<S>> {
    protected int iterations;
    protected int maxIterations;
    protected SolutionListEvaluator<S> evaluator;
    protected Vector<Integer> numberOfDivisions;
    protected List<ReferencePoint<S>> referencePoints = new Vector<ReferencePoint<S>>();

    public NSGAIII(NSGAIIIBuilder<S> builder) {
        super(builder.getProblem());
        this.maxIterations = builder.getMaxIterations();
        this.crossoverOperator = builder.getCrossoverOperator();
        this.mutationOperator = builder.getMutationOperator();
        this.selectionOperator = builder.getSelectionOperator();
        this.evaluator = builder.getEvaluator();
        this.numberOfDivisions = new Vector(1);
        this.numberOfDivisions.add(12);
        new ReferencePoint<S>().generateReferencePoints(this.referencePoints, this.getProblem().getNumberOfObjectives(), this.numberOfDivisions);
        int populationSize = this.referencePoints.size();
        while (populationSize % 4 > 0) {
            ++populationSize;
        }
        this.setMaxPopulationSize(populationSize);
        JMetalLogger.logger.info("rpssize: " + this.referencePoints.size());
    }

    @Override
    protected void initProgress() {
        this.iterations = 1;
    }

    @Override
    protected void updateProgress() {
        ++this.iterations;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.iterations >= this.maxIterations;
    }

    @Override
    protected List<S> evaluatePopulation(List<S> population) {
        population = this.evaluator.evaluate(population, this.getProblem());
        return population;
    }

    @Override
    protected List<S> selection(List<S> population) {
        ArrayList<Solution> matingPopulation = new ArrayList<Solution>(population.size());
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            Solution solution = (Solution)this.selectionOperator.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    @Override
    protected List<S> reproduction(List<S> population) {
        ArrayList offspringPopulation = new ArrayList(this.getMaxPopulationSize());
        for (int i = 0; i < this.getMaxPopulationSize(); i += 2) {
            ArrayList<S> parents = new ArrayList<S>(2);
            parents.add(population.get(i));
            parents.add(population.get(Math.min(i + 1, this.getMaxPopulationSize() - 1)));
            List offspring = (List)this.crossoverOperator.execute(parents);
            this.mutationOperator.execute(offspring.get(0));
            this.mutationOperator.execute(offspring.get(1));
            offspringPopulation.add(offspring.get(0));
            offspringPopulation.add(offspring.get(1));
        }
        return offspringPopulation;
    }

    private List<ReferencePoint<S>> getReferencePointsCopy() {
        ArrayList<ReferencePoint<S>> copy = new ArrayList<ReferencePoint<S>>();
        for (ReferencePoint<S> r : this.referencePoints) {
            copy.add(new ReferencePoint<S>(r));
        }
        return copy;
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(population);
        jointPopulation.addAll(offspringPopulation);
        Ranking ranking = this.computeRanking(jointPopulation);
        List<Object> pop = new ArrayList();
        ArrayList fronts = new ArrayList();
        int rankingIndex = 0;
        int candidateSolutions = 0;
        while (candidateSolutions < this.getMaxPopulationSize()) {
            fronts.add(ranking.getSubfront(rankingIndex));
            candidateSolutions += ranking.getSubfront(rankingIndex).size();
            if (pop.size() + ranking.getSubfront(rankingIndex).size() <= this.getMaxPopulationSize()) {
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, pop);
            }
            ++rankingIndex;
        }
        EnvironmentalSelection selection = new EnvironmentalSelection(fronts, this.getMaxPopulationSize(), this.getReferencePointsCopy(), this.getProblem().getNumberOfObjectives());
        pop = selection.execute(pop);
        return pop;
    }

    @Override
    public List<S> getResult() {
        return this.getNonDominatedSolutions(this.getPopulation());
    }

    protected Ranking<S> computeRanking(List<S> solutionList) {
        DominanceRanking<S> ranking = new DominanceRanking<S>();
        ranking.computeRanking(solutionList);
        return ranking;
    }

    protected void addRankedSolutionsToPopulation(Ranking<S> ranking, int rank, List<S> population) {
        List<S> front = ranking.getSubfront(rank);
        for (int i = 0; i < front.size(); ++i) {
            population.add(front.get(i));
        }
    }

    protected List<S> getNonDominatedSolutions(List<S> solutionList) {
        return SolutionListUtils.getNondominatedSolutions(solutionList);
    }

    @Override
    public String getName() {
        return "NSGAIII";
    }

    @Override
    public String getDescription() {
        return "Nondominated Sorting Genetic Algorithm version III";
    }
}

