/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaiii.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class ReferencePoint<S extends Solution<?>> {
    public List<Double> position;
    private int memberSize;
    private List<Pair<S, Double>> potentialMembers;

    public ReferencePoint() {
    }

    public ReferencePoint(int size) {
        this.position = new ArrayList<Double>();
        for (int i = 0; i < size; ++i) {
            this.position.add(0.0);
        }
        this.memberSize = 0;
        this.potentialMembers = new ArrayList<Pair<S, Double>>();
    }

    public ReferencePoint(ReferencePoint<S> point) {
        this.position = new ArrayList<Double>(point.position.size());
        for (Double d : point.position) {
            this.position.add(new Double(d));
        }
        this.memberSize = 0;
        this.potentialMembers = new ArrayList<Pair<S, Double>>();
    }

    public void generateReferencePoints(List<ReferencePoint<S>> referencePoints, int numberOfObjectives, List<Integer> numberOfDivisions) {
        ReferencePoint<S> refPoint = new ReferencePoint<S>(numberOfObjectives);
        this.generateRecursive(referencePoints, refPoint, numberOfObjectives, numberOfDivisions.get(0), numberOfDivisions.get(0), 0);
    }

    private void generateRecursive(List<ReferencePoint<S>> referencePoints, ReferencePoint<S> refPoint, int numberOfObjectives, int left, int total, int element) {
        if (element == numberOfObjectives - 1) {
            refPoint.position.set(element, (double)left / (double)total);
            referencePoints.add(new ReferencePoint<S>(refPoint));
        } else {
            for (int i = 0; i <= left; ++i) {
                refPoint.position.set(element, (double)i / (double)total);
                this.generateRecursive(referencePoints, refPoint, numberOfObjectives, left - i, total, element + 1);
            }
        }
    }

    public List<Double> pos() {
        return this.position;
    }

    public int MemberSize() {
        return this.memberSize;
    }

    public boolean HasPotentialMember() {
        return this.potentialMembers.size() > 0;
    }

    public void clear() {
        this.memberSize = 0;
        this.potentialMembers.clear();
    }

    public void AddMember() {
        ++this.memberSize;
    }

    public void AddPotentialMember(S member_ind, double distance) {
        this.potentialMembers.add(new ImmutablePair<S, Double>(member_ind, distance));
    }

    public S FindClosestMember() {
        double minDistance = Double.MAX_VALUE;
        Solution closetMember = null;
        for (Pair<S, Double> p : this.potentialMembers) {
            if (!(p.getRight() < minDistance)) continue;
            minDistance = p.getRight();
            closetMember = (Solution)p.getLeft();
        }
        return (S)closetMember;
    }

    public S RandomMember() {
        int index = this.potentialMembers.size() > 1 ? JMetalRandom.getInstance().nextInt(0, this.potentialMembers.size() - 1) : 0;
        return (S)((Solution)this.potentialMembers.get(index).getLeft());
    }

    public void RemovePotentialMember(S solution) {
        Iterator<Pair<S, Double>> it = this.potentialMembers.iterator();
        while (it.hasNext()) {
            if (!((Solution)it.next().getLeft()).equals(solution)) continue;
            it.remove();
            break;
        }
    }
}

