/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.rnsgaii.util;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.solution.Solution;

public class PreferenceNSGAII<S extends Solution<?>> {
    private List<Double> interestPoint;
    private List<Double> upperBounds = null;
    private List<Double> lowerBounds = null;
    private List<Double> weights = null;

    public PreferenceNSGAII(List<Double> weights) {
        this.weights = weights;
    }

    public void updatePointOfInterest(List<Double> newInterestPoint) {
        this.interestPoint = newInterestPoint;
    }

    public Double evaluate(S solution) {
        ArrayList<Double> objectiveValues = new ArrayList<Double>(solution.getNumberOfObjectives());
        for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
            objectiveValues.add(solution.getObjective(i));
        }
        double normalizeDiff = 0.0;
        double distance = 0.0;
        for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
            normalizeDiff = this.upperBounds != null && this.lowerBounds != null ? (solution.getObjective(i) - this.interestPoint.get(i)) / (this.upperBounds.get(i) - this.lowerBounds.get(i)) : solution.getObjective(i) - this.interestPoint.get(i);
            distance += this.weights.get(i) * Math.pow(normalizeDiff, 2.0);
        }
        return Math.sqrt(distance);
    }

    public int getSize() {
        return this.weights.size();
    }

    public void setUpperBounds(List<Double> upperBounds) {
        this.upperBounds = upperBounds;
    }

    public void setLowerBounds(List<Double> lowerBounds) {
        this.lowerBounds = lowerBounds;
    }
}

