/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.wasfga;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.InteractiveAlgorithm;
import org.uma.jmetal.algorithm.multiobjective.mombi.AbstractMOMBI;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.ASFWASFGA;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.AbstractUtilityFunctionsSet;
import org.uma.jmetal.algorithm.multiobjective.wasfga.util.WASFGARanking;
import org.uma.jmetal.algorithm.multiobjective.wasfga.util.WeightVectors;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.Ranking;

public class WASFGA<S extends Solution<?>>
extends AbstractMOMBI<S>
implements InteractiveAlgorithm<S, List<S>> {
    private static final long serialVersionUID = 1L;
    protected int maxEvaluations;
    protected int evaluations;
    protected double epsilon;
    protected double[][] weights;
    private final AbstractUtilityFunctionsSet<S> achievementScalarizingFunction;
    private List<Double> interestPoint = null;
    private String weightVectorsFileName = "";

    public WASFGA(Problem<S> problem, int populationSize, int maxIterations, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator, double epsilon, List<Double> referencePoint, String weightVectorsFileName) {
        super(problem, maxIterations, crossoverOperator, mutationOperator, selectionOperator, evaluator);
        this.weightVectorsFileName = weightVectorsFileName;
        this.setMaxPopulationSize(populationSize);
        this.interestPoint = referencePoint;
        this.achievementScalarizingFunction = this.createUtilityFunction();
        this.epsilon = epsilon;
    }

    public WASFGA(Problem<S> problem, int populationSize, int maxIterations, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator, double epsilon, List<Double> referencePoint) {
        this(problem, populationSize, maxIterations, crossoverOperator, mutationOperator, selectionOperator, evaluator, epsilon, referencePoint, "");
    }

    public AbstractUtilityFunctionsSet<S> createUtilityFunction() {
        if ("".equals(this.weightVectorsFileName)) {
            if (this.problem.getNumberOfObjectives() == 2) {
                this.weights = WeightVectors.initializeUniformlyInTwoDimensions(this.epsilon, this.getMaxPopulationSize());
            } else {
                String dataFileName = "W" + this.problem.getNumberOfObjectives() + "D_" + this.getMaxPopulationSize() + ".dat";
                this.weights = WeightVectors.readFromResourcesInJMetal("MOEAD_Weights/" + dataFileName);
            }
        } else {
            this.weights = WeightVectors.readFromFile(this.weightVectorsFileName);
        }
        this.weights = WeightVectors.invert(this.weights, true);
        if (!WeightVectors.validate(this.weights, this.problem.getNumberOfObjectives())) {
            throw new JMetalException("Weight vectors are invalid. Check that weight vectors have as many components as objectives the problem being solved has.");
        }
        if (this.weights.length != this.maxPopulationSize) {
            throw new JMetalException("The number of weight vectors (" + this.weights.length + ") and the population size (" + this.maxPopulationSize + ") have different values. This behaviour will change in a future version.");
        }
        return new ASFWASFGA(this.weights, this.interestPoint);
    }

    @Override
    public void updatePointOfInterest(List<Double> newPointOfInterest) {
        ((ASFWASFGA)this.achievementScalarizingFunction).updatePointOfInterest(newPointOfInterest);
    }

    public int getPopulationSize() {
        return this.getMaxPopulationSize();
    }

    @Override
    public void specificMOEAComputations() {
        this.updateNadirPoint(this.getPopulation());
        this.updateReferencePoint(this.getPopulation());
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(population);
        jointPopulation.addAll(offspringPopulation);
        Ranking ranking = this.computeRanking(jointPopulation);
        return this.selectBest(ranking);
    }

    protected Ranking<S> computeRanking(List<S> solutionList) {
        WASFGARanking<S> ranking = new WASFGARanking<S>(this.achievementScalarizingFunction);
        ranking.computeRanking(solutionList);
        return ranking;
    }

    protected void addRankedSolutionsToPopulation(Ranking<S> ranking, int index, List<S> population) {
        population.addAll(ranking.getSubfront(index));
    }

    protected void addLastRankedSolutionsToPopulation(Ranking<S> ranking, int index, List<S> population) {
        List<S> front = ranking.getSubfront(index);
        int remain = this.getPopulationSize() - population.size();
        population.addAll(front.subList(0, remain));
    }

    protected List<S> selectBest(Ranking<S> ranking) {
        ArrayList population = new ArrayList(this.getPopulationSize());
        int rankingIndex = 0;
        while (this.populationIsNotFull(population)) {
            if (this.subfrontFillsIntoThePopulation(ranking, rankingIndex, population)) {
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, population);
                ++rankingIndex;
                continue;
            }
            this.addLastRankedSolutionsToPopulation(ranking, rankingIndex, population);
        }
        return population;
    }

    private boolean subfrontFillsIntoThePopulation(Ranking<S> ranking, int index, List<S> population) {
        return population.size() + ranking.getSubfront(index).size() < this.getPopulationSize();
    }

    @Override
    public List<S> getResult() {
        return this.getNonDominatedSolutions(this.getPopulation());
    }

    protected List<S> getNonDominatedSolutions(List<S> solutionList) {
        return SolutionListUtils.getNondominatedSolutions(solutionList);
    }

    @Override
    public String getName() {
        return "WASFGA";
    }

    @Override
    public String getDescription() {
        return "Weighting Achievement Scalarizing Function Genetic Algorithm";
    }
}

