/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.singleobjective.differentialevolution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractDifferentialEvolution;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.selection.DifferentialEvolutionSelection;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class DifferentialEvolution
extends AbstractDifferentialEvolution<DoubleSolution> {
    private int populationSize;
    private int maxEvaluations;
    private SolutionListEvaluator<DoubleSolution> evaluator;
    private Comparator<DoubleSolution> comparator;
    private int evaluations;

    public DifferentialEvolution(DoubleProblem problem, int maxEvaluations, int populationSize, DifferentialEvolutionCrossover crossoverOperator, DifferentialEvolutionSelection selectionOperator, SolutionListEvaluator<DoubleSolution> evaluator) {
        this.setProblem(problem);
        this.maxEvaluations = maxEvaluations;
        this.populationSize = populationSize;
        this.crossoverOperator = crossoverOperator;
        this.selectionOperator = selectionOperator;
        this.evaluator = evaluator;
        this.comparator = new ObjectiveComparator<DoubleSolution>(0);
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    public void setEvaluations(int evaluations) {
        this.evaluations = evaluations;
    }

    @Override
    protected void initProgress() {
        this.evaluations = this.populationSize;
    }

    @Override
    protected void updateProgress() {
        this.evaluations += this.populationSize;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    @Override
    protected List<DoubleSolution> createInitialPopulation() {
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            DoubleSolution newIndividual = (DoubleSolution)this.getProblem().createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    @Override
    protected List<DoubleSolution> evaluatePopulation(List<DoubleSolution> population) {
        return this.evaluator.evaluate(population, this.getProblem());
    }

    @Override
    protected List<DoubleSolution> selection(List<DoubleSolution> population) {
        return population;
    }

    @Override
    protected List<DoubleSolution> reproduction(List<DoubleSolution> matingPopulation) {
        ArrayList<DoubleSolution> offspringPopulation = new ArrayList<DoubleSolution>();
        for (int i = 0; i < this.populationSize; ++i) {
            this.selectionOperator.setIndex(i);
            List<DoubleSolution> parents = this.selectionOperator.execute(matingPopulation);
            this.crossoverOperator.setCurrentSolution(matingPopulation.get(i));
            List<DoubleSolution> children = this.crossoverOperator.execute(parents);
            offspringPopulation.add(children.get(0));
        }
        return offspringPopulation;
    }

    @Override
    protected List<DoubleSolution> replacement(List<DoubleSolution> population, List<DoubleSolution> offspringPopulation) {
        ArrayList<DoubleSolution> pop = new ArrayList<DoubleSolution>();
        for (int i = 0; i < this.populationSize; ++i) {
            if (this.comparator.compare(population.get(i), offspringPopulation.get(i)) < 0) {
                pop.add(population.get(i));
                continue;
            }
            pop.add(offspringPopulation.get(i));
        }
        Collections.sort(pop, this.comparator);
        return pop;
    }

    @Override
    public DoubleSolution getResult() {
        Collections.sort(this.getPopulation(), this.comparator);
        return (DoubleSolution)this.getPopulation().get(0);
    }

    @Override
    public String getName() {
        return "DE";
    }

    @Override
    public String getDescription() {
        return "Differential Evolution Algorithm";
    }
}

