/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.experiment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.gde3.GDE3Builder;
import org.uma.jmetal.algorithm.multiobjective.mocell.MOCellBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOBuilder;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2Builder;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.operator.impl.selection.DifferentialEvolutionSelection;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.multiobjective.Binh2;
import org.uma.jmetal.problem.multiobjective.ConstrEx;
import org.uma.jmetal.problem.multiobjective.Golinski;
import org.uma.jmetal.problem.multiobjective.Srinivas;
import org.uma.jmetal.problem.multiobjective.Tanaka;
import org.uma.jmetal.problem.multiobjective.Water;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentBuilder;
import org.uma.jmetal.util.experiment.component.ComputeQualityIndicators;
import org.uma.jmetal.util.experiment.component.ExecuteAlgorithms;
import org.uma.jmetal.util.experiment.component.GenerateBoxplotsWithR;
import org.uma.jmetal.util.experiment.component.GenerateFriedmanTestTables;
import org.uma.jmetal.util.experiment.component.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.util.experiment.component.GenerateReferenceParetoSetAndFrontFromDoubleSolutions;
import org.uma.jmetal.util.experiment.component.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.util.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;

public class ConstraintProblemsStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Needed arguments: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        ArrayList problemList = new ArrayList();
        problemList.add(new ExperimentProblem<DoubleSolution>(new Binh2()));
        problemList.add(new ExperimentProblem<DoubleSolution>(new ConstrEx()));
        problemList.add(new ExperimentProblem<DoubleSolution>(new Golinski()));
        problemList.add(new ExperimentProblem<DoubleSolution>(new Srinivas()));
        problemList.add(new ExperimentProblem<DoubleSolution>(new Tanaka()));
        problemList.add(new ExperimentProblem<DoubleSolution>(new Water()));
        List algorithmList = ConstraintProblemsStudy.configureAlgorithmList(problemList);
        Experiment experiment = new ExperimentBuilder("ConstrainedProblemsStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setReferenceFrontDirectory(experimentBaseDirectory + "/ConstrainedProblemsStudy/referenceFronts").setIndicatorList(Arrays.asList(new Epsilon(), new PISAHypervolume(), new InvertedGenerationalDistancePlus())).setIndependentRuns(25).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new GenerateReferenceParetoSetAndFrontFromDoubleSolutions(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(3).setColumns(3).run();
    }

    static List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> configureAlgorithmList(List<ExperimentProblem<DoubleSolution>> problemList) {
        Algorithm<List<DoubleSolution>> algorithm;
        Algorithm algorithm2;
        int i;
        ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms = new ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>>();
        for (i = 0; i < problemList.size(); ++i) {
            algorithm2 = new NSGAIIBuilder<DoubleSolution>(problemList.get(i).getProblem(), new SBXCrossover(1.0, 20.0), new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 20.0)).setMaxEvaluations(25000).setPopulationSize(100).build();
            algorithms.add(new ExperimentAlgorithm(algorithm2, problemList.get(i).getTag()));
        }
        for (i = 0; i < problemList.size(); ++i) {
            algorithm2 = new SPEA2Builder<DoubleSolution>(problemList.get(i).getProblem(), new SBXCrossover(1.0, 10.0), new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 20.0)).build();
            algorithms.add(new ExperimentAlgorithm(algorithm2, problemList.get(i).getTag()));
        }
        for (i = 0; i < problemList.size(); ++i) {
            double mutationProbability = 1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables();
            double mutationDistributionIndex = 20.0;
            algorithm = new SMPSOBuilder((DoubleProblem)problemList.get(i).getProblem(), new CrowdingDistanceArchive<DoubleSolution>(100)).setMutation(new PolynomialMutation(mutationProbability, mutationDistributionIndex)).setMaxIterations(250).setSwarmSize(100).setSolutionListEvaluator(new SequentialSolutionListEvaluator<DoubleSolution>()).build();
            algorithms.add(new ExperimentAlgorithm(algorithm, problemList.get(i).getTag()));
        }
        for (i = 0; i < problemList.size(); ++i) {
            double cr = 0.5;
            double f = 0.5;
            algorithm = new GDE3Builder((DoubleProblem)problemList.get(i).getProblem()).setCrossover(new DifferentialEvolutionCrossover(cr, f, "rand/1/bin")).setSelection(new DifferentialEvolutionSelection()).setMaxEvaluations(25000).setPopulationSize(100).setSolutionSetEvaluator(new SequentialSolutionListEvaluator<DoubleSolution>()).build();
            algorithms.add(new ExperimentAlgorithm(algorithm, problemList.get(i).getTag()));
        }
        for (i = 0; i < problemList.size(); ++i) {
            Algorithm algorithm3 = new MOCellBuilder<DoubleSolution>((DoubleProblem)problemList.get(i).getProblem(), new SBXCrossover(1.0, 20.0), new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 20.0)).setSelectionOperator(new BinaryTournamentSelection()).setMaxEvaluations(25000).setPopulationSize(100).setArchive(new CrowdingDistanceArchive(100)).build();
            algorithms.add(new ExperimentAlgorithm(algorithm3, problemList.get(i).getTag()));
        }
        return algorithms;
    }
}

