/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.crossover;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.util.RepairDoubleSolution;
import org.uma.jmetal.solution.util.RepairDoubleSolutionAtBounds;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class BLXAlphaCrossover
implements CrossoverOperator<DoubleSolution> {
    private static final double DEFAULT_ALPHA = 0.5;
    private double crossoverProbability;
    private double alpha;
    private RepairDoubleSolution solutionRepair;
    private RandomGenerator<Double> randomGenerator;

    public BLXAlphaCrossover(double crossoverProbability) {
        this(crossoverProbability, 0.5, new RepairDoubleSolutionAtBounds());
    }

    public BLXAlphaCrossover(double crossoverProbability, double alpha) {
        this(crossoverProbability, alpha, new RepairDoubleSolutionAtBounds());
    }

    public BLXAlphaCrossover(double crossoverProbability, double alpha, RepairDoubleSolution solutionRepair) {
        this(crossoverProbability, alpha, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public BLXAlphaCrossover(double crossoverProbability, double alpha, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        if (crossoverProbability < 0.0) {
            throw new JMetalException("Crossover probability is negative: " + crossoverProbability);
        }
        if (alpha < 0.0) {
            throw new JMetalException("Alpha is negative: " + alpha);
        }
        this.crossoverProbability = crossoverProbability;
        this.alpha = alpha;
        this.randomGenerator = randomGenerator;
        this.solutionRepair = solutionRepair;
    }

    public double getCrossoverProbability() {
        return this.crossoverProbability;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setCrossoverProbability(double crossoverProbability) {
        this.crossoverProbability = crossoverProbability;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutions) {
        if (null == solutions) {
            throw new JMetalException("Null parameter");
        }
        if (solutions.size() != 2) {
            throw new JMetalException("There must be two parents instead of " + solutions.size());
        }
        return this.doCrossover(this.crossoverProbability, solutions.get(0), solutions.get(1));
    }

    public List<DoubleSolution> doCrossover(double probability, DoubleSolution parent1, DoubleSolution parent2) {
        ArrayList<DoubleSolution> offspring = new ArrayList<DoubleSolution>(2);
        offspring.add((DoubleSolution)parent1.copy());
        offspring.add((DoubleSolution)parent2.copy());
        if (this.randomGenerator.getRandomValue() <= probability) {
            for (int i = 0; i < parent1.getNumberOfVariables(); ++i) {
                double min;
                double max;
                double upperBound = parent1.getUpperBound(i);
                double lowerBound = parent1.getLowerBound(i);
                double valueX1 = (Double)parent1.getVariableValue(i);
                double valueX2 = (Double)parent2.getVariableValue(i);
                if (valueX2 > valueX1) {
                    max = valueX2;
                    min = valueX1;
                } else {
                    max = valueX1;
                    min = valueX2;
                }
                double range = max - min;
                double minRange = min - range * this.alpha;
                double maxRange = max + range * this.alpha;
                double random = this.randomGenerator.getRandomValue();
                double valueY1 = minRange + random * (maxRange - minRange);
                random = this.randomGenerator.getRandomValue();
                double valueY2 = minRange + random * (maxRange - minRange);
                valueY1 = this.solutionRepair.repairSolutionVariableValue(valueY1, lowerBound, upperBound);
                valueY2 = this.solutionRepair.repairSolutionVariableValue(valueY2, lowerBound, upperBound);
                ((DoubleSolution)offspring.get(0)).setVariableValue(i, valueY1);
                ((DoubleSolution)offspring.get(1)).setVariableValue(i, valueY2);
            }
        }
        return offspring;
    }

    @Override
    public int getNumberOfRequiredParents() {
        return 2;
    }

    @Override
    public int getNumberOfGeneratedChildren() {
        return 2;
    }
}

