/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cdtlz;

import org.uma.jmetal.problem.ConstrainedProblem;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ1;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;
import org.uma.jmetal.util.solutionattribute.impl.OverallConstraintViolation;

public class C1_DTLZ1
extends DTLZ1
implements ConstrainedProblem<DoubleSolution> {
    public OverallConstraintViolation<DoubleSolution> overallConstraintViolationDegree;
    public NumberOfViolatedConstraints<DoubleSolution> numberOfViolatedConstraints;

    public C1_DTLZ1(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
        this.setNumberOfConstraints(1);
        this.overallConstraintViolationDegree = new OverallConstraintViolation();
        this.numberOfViolatedConstraints = new NumberOfViolatedConstraints();
    }

    @Override
    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double sum = 0.0;
        for (int i = 0; i < this.getNumberOfObjectives() - 2; ++i) {
            sum += solution.getObjective(i) / 0.5;
        }
        constraint[0] = 1.0 - solution.getObjective(this.getNumberOfObjectives() - 1) - sum;
        double overallConstraintViolation = 0.0;
        int violatedConstraints = 0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            overallConstraintViolation += constraint[i];
            ++violatedConstraints;
        }
        this.overallConstraintViolationDegree.setAttribute(solution, overallConstraintViolation);
        this.numberOfViolatedConstraints.setAttribute(solution, violatedConstraints);
    }
}

