/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cdtlz;

import org.uma.jmetal.problem.ConstrainedProblem;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ2;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;
import org.uma.jmetal.util.solutionattribute.impl.OverallConstraintViolation;

public class C2_DTLZ2
extends DTLZ2
implements ConstrainedProblem<DoubleSolution> {
    public OverallConstraintViolation<DoubleSolution> overallConstraintViolationDegree;
    public NumberOfViolatedConstraints<DoubleSolution> numberOfViolatedConstraints;
    private double rValue;

    public C2_DTLZ2(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
        this.setNumberOfConstraints(1);
        this.rValue = this.getNumberOfObjectives() == 3 ? 0.4 : 0.5;
        this.overallConstraintViolationDegree = new OverallConstraintViolation();
        this.numberOfViolatedConstraints = new NumberOfViolatedConstraints();
    }

    @Override
    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double sum2 = 0.0;
        double maxSum1 = Double.MIN_VALUE;
        for (int i = 0; i < this.getNumberOfObjectives(); ++i) {
            double sum1 = Math.pow(solution.getObjective(i) - 1.0, 2.0) - Math.pow(this.rValue, 2.0);
            for (int j = 0; j < this.getNumberOfObjectives(); ++j) {
                if (i == j) continue;
                sum1 += Math.pow(solution.getObjective(j), 2.0);
            }
            maxSum1 = Math.max(maxSum1, sum1);
            sum2 += Math.pow(solution.getObjective(i) - 1.0 / Math.sqrt(this.getNumberOfObjectives()), 2.0);
        }
        constraint[0] = Math.max(maxSum1, sum2 -= Math.pow(this.rValue, 2.0));
        double overallConstraintViolation = 0.0;
        int violatedConstraints = 0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            overallConstraintViolation += constraint[i];
            ++violatedConstraints;
        }
        this.overallConstraintViolationDegree.setAttribute(solution, overallConstraintViolation);
        this.numberOfViolatedConstraints.setAttribute(solution, violatedConstraints);
    }
}

