/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective.cec2005competitioncode;

import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.Benchmark;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.TestFunc;
import org.uma.jmetal.util.JMetalException;

public class F02ShiftedSchwefel
extends TestFunc {
    public static final String FUNCTION_NAME = "Shifted Schwefel's Problem 1.2";
    public static final String DEFAULT_FILE_DATA = "cec2005CompetitionResources/supportData/schwefel_102_data.txt";
    private final double[] m_o;
    private double[] m_z;

    public F02ShiftedSchwefel(int dimension, double bias) throws JMetalException {
        this(dimension, bias, DEFAULT_FILE_DATA);
    }

    public F02ShiftedSchwefel(int dimension, double bias, String file_data) throws JMetalException {
        super(dimension, bias, FUNCTION_NAME);
        this.m_o = new double[this.mDimension];
        this.m_z = new double[this.mDimension];
        Benchmark.loadRowVectorFromFile(file_data, this.mDimension, this.m_o);
    }

    @Override
    public double f(double[] x) {
        double result = 0.0;
        Benchmark.shift(this.m_z, x, this.m_o);
        result = Benchmark.schwefel_102(this.m_z);
        return result += this.mBias;
    }
}

