/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;

public class Epsilon<S extends Solution<?>>
extends GenericIndicator<S> {
    public Epsilon() {
    }

    public Epsilon(String referenceParetoFrontFile) throws FileNotFoundException {
        super(referenceParetoFrontFile);
    }

    public Epsilon(Front referenceParetoFront) {
        super(referenceParetoFront);
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }

    @Override
    public Double evaluate(List<S> solutionList) {
        if (solutionList == null) {
            throw new JMetalException("The pareto front approximation list is null");
        }
        return this.epsilon(new ArrayFront(solutionList), this.referenceParetoFront);
    }

    private double epsilon(Front front, Front referenceFront) throws JMetalException {
        double epsJ = 0.0;
        double epsK = 0.0;
        int numberOfObjectives = front.getPointDimensions();
        double eps = Double.MIN_VALUE;
        for (int i = 0; i < referenceFront.getNumberOfPoints(); ++i) {
            for (int j = 0; j < front.getNumberOfPoints(); ++j) {
                for (int k = 0; k < numberOfObjectives; ++k) {
                    double epsTemp = front.getPoint(j).getDimensionValue(k) - referenceFront.getPoint(i).getDimensionValue(k);
                    if (k == 0) {
                        epsK = epsTemp;
                        continue;
                    }
                    if (!(epsK < epsTemp)) continue;
                    epsK = epsTemp;
                }
                if (j == 0) {
                    epsJ = epsK;
                    continue;
                }
                if (!(epsJ > epsK)) continue;
                epsJ = epsK;
            }
            if (i == 0) {
                eps = epsJ;
                continue;
            }
            if (!(eps < epsJ)) continue;
            eps = epsJ;
        }
        return eps;
    }

    @Override
    public String getName() {
        return "EP";
    }

    @Override
    public String getDescription() {
        return "Additive Epsilon quality indicator";
    }
}

