/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontUtils;

public class GenerationalDistance<S extends Solution<?>>
extends GenericIndicator<S> {
    private double pow = 2.0;

    public GenerationalDistance() {
    }

    public GenerationalDistance(String referenceParetoFrontFile, double p) throws FileNotFoundException {
        super(referenceParetoFrontFile);
        this.pow = p;
    }

    public GenerationalDistance(String referenceParetoFrontFile) throws FileNotFoundException {
        this(referenceParetoFrontFile, 2.0);
    }

    public GenerationalDistance(Front referenceParetoFront) {
        super(referenceParetoFront);
    }

    @Override
    public Double evaluate(List<S> solutionList) {
        if (solutionList == null) {
            throw new JMetalException("The pareto front approximation is null");
        }
        return this.generationalDistance(new ArrayFront(solutionList), this.referenceParetoFront);
    }

    public double generationalDistance(Front front, Front referenceFront) {
        double sum = 0.0;
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            sum += Math.pow(FrontUtils.distanceToClosestPoint(front.getPoint(i), referenceFront), this.pow);
        }
        sum = Math.pow(sum, 1.0 / this.pow);
        return sum / (double)front.getNumberOfPoints();
    }

    @Override
    public String getName() {
        return "GD";
    }

    @Override
    public String getDescription() {
        return "Generational distance quality indicator";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }
}

