/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.util.List;
import org.knowm.xchart.BitmapEncoder;
import org.uma.jmetal.algorithm.multiobjective.dmopso.DMOPSO;
import org.uma.jmetal.algorithm.multiobjective.dmopso.DMOPSOMeasures;
import org.uma.jmetal.measure.MeasureListener;
import org.uma.jmetal.measure.MeasureManager;
import org.uma.jmetal.measure.impl.BasicMeasure;
import org.uma.jmetal.measure.impl.CountingMeasure;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.chartcontainer.ChartContainer;
import org.uma.jmetal.util.front.imp.ArrayFront;

public class DMOPSOMeasuresRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws Exception {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT4";
            referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/ZDT1.pf";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem(problemName);
        DMOPSOMeasures algorithm = new DMOPSOMeasures(problem, 100, 150, 0.0, 0.1, 0.0, 1.0, 1.5, 2.5, 1.5, 2.5, 0.1, 0.4, -1.0, -1.0, DMOPSO.FunctionType.TCHE, "MOEAD_Weights", 2);
        algorithm.setReferenceFront(new ArrayFront(referenceParetoFront));
        MeasureManager measureManager = algorithm.getMeasureManager();
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure("currentPopulation");
        CountingMeasure iterationMeasure = (CountingMeasure)measureManager.getPushMeasure("currentEvaluation");
        BasicMeasure hypervolumeMeasure = (BasicMeasure)measureManager.getPushMeasure("hypervolume");
        BasicMeasure epsilonMeasure = (BasicMeasure)measureManager.getPushMeasure("epsilon");
        ChartContainer chart = new ChartContainer(algorithm.getName(), 200);
        chart.setFrontChart(0, 1, referenceParetoFront);
        chart.setVarChart(0, 1);
        chart.addIndicatorChart("Hypervolume");
        chart.addIndicatorChart("Epsilon");
        chart.initChart();
        solutionListMeasure.register(new ChartListener(chart));
        iterationMeasure.register(new IterationListener(chart));
        hypervolumeMeasure.register(new IndicatorListener("Hypervolume", chart));
        epsilonMeasure.register(new IndicatorListener("Epsilon", chart));
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        chart.saveChart("./chart", BitmapEncoder.BitmapFormat.PNG);
        Object population = algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        DMOPSOMeasuresRunner.printFinalSolutionSet(population);
        if (!referenceParetoFront.equals("")) {
            DMOPSOMeasuresRunner.printQualityIndicators(population, referenceParetoFront);
        }
    }

    private static class IndicatorListener
    implements MeasureListener<Double> {
        ChartContainer chart;
        String indicator;

        public IndicatorListener(String indicator, ChartContainer chart) {
            this.chart = chart;
            this.indicator = indicator;
        }

        @Override
        public synchronized void measureGenerated(Double value) {
            if (this.chart != null) {
                this.chart.updateIndicatorChart(this.indicator, value);
                this.chart.refreshCharts(0);
            }
        }
    }

    private static class IterationListener
    implements MeasureListener<Long> {
        ChartContainer chart;

        public IterationListener(ChartContainer chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: 0");
        }

        @Override
        public synchronized void measureGenerated(Long iteration) {
            if (this.chart != null) {
                this.chart.getFrontChart().setTitle("Iteration: " + iteration);
            }
        }
    }

    private static class ChartListener
    implements MeasureListener<List<DoubleSolution>> {
        private ChartContainer chart;
        private int iteration = 0;

        public ChartListener(ChartContainer chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
        }

        private void refreshChart(List<DoubleSolution> solutionList) {
            if (this.chart != null) {
                ++this.iteration;
                this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
                this.chart.updateFrontCharts(solutionList);
                this.chart.refreshCharts();
            }
        }

        @Override
        public synchronized void measureGenerated(List<DoubleSolution> solutions) {
            this.refreshChart(solutions);
        }
    }
}

