/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.MOEADBuilder;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;

public class MOEADSTMRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.lz09.LZ09F2";
            referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/LZ09_F2.pf";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem(problemName);
        double cr = 1.0;
        double f = 0.5;
        DifferentialEvolutionCrossover crossover = new DifferentialEvolutionCrossover(cr, f, "rand/1/bin");
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        Algorithm algorithm = new MOEADBuilder(problem, MOEADBuilder.Variant.MOEADSTM).setCrossover(crossover).setMutation(mutation).setMaxEvaluations(150000).setPopulationSize(300).setResultPopulationSize(300).setNeighborhoodSelectionProbability(0.9).setMaximumNumberOfReplacedSolutions(2).setNeighborSize(20).setFunctionType(AbstractMOEAD.FunctionType.TCHE).setDataDirectory("MOEAD_Weights").build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        MOEADSTMRunner.printFinalSolutionSet(population);
        if (!referenceParetoFront.equals("")) {
            MOEADSTMRunner.printQualityIndicators(population, referenceParetoFront);
        }
    }
}

