/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.operator.impl.crossover.IntegerSBXCrossover;
import org.uma.jmetal.operator.impl.mutation.IntegerPolynomialMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.IntegerSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;

public class NSGAIIIntegerRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.NMMin";
            referenceParetoFront = "";
        }
        Problem problem = ProblemUtils.loadProblem(problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        IntegerSBXCrossover crossover = new IntegerSBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        IntegerPolynomialMutation mutation = new IntegerPolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection();
        Algorithm algorithm = new NSGAIIBuilder<IntegerSolution>(problem, crossover, mutation).setSelectionOperator(selection).setMaxEvaluations(25000).setPopulationSize(100).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        NSGAIIIntegerRunner.printFinalSolutionSet(population);
        if (!referenceParetoFront.equals("")) {
            NSGAIIIntegerRunner.printQualityIndicators(population, referenceParetoFront);
        }
    }
}

