/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.IOException;
import java.util.List;
import org.knowm.xchart.BitmapEncoder;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSO;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOBuilder;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOMeasures;
import org.uma.jmetal.measure.MeasureListener;
import org.uma.jmetal.measure.MeasureManager;
import org.uma.jmetal.measure.impl.BasicMeasure;
import org.uma.jmetal.measure.impl.CountingMeasure;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.chartcontainer.ChartContainer;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.pseudorandom.impl.MersenneTwisterGenerator;

public class SMPSOMeasuresWithChartsRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, InterruptedException, IOException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT4";
            referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/ZDT4.pf";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem(problemName);
        CrowdingDistanceArchive<DoubleSolution> archive = new CrowdingDistanceArchive<DoubleSolution>(100);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        int maxIterations = 250;
        int swarmSize = 100;
        SMPSO algorithm = new SMPSOBuilder(problem, archive).setMutation(mutation).setMaxIterations(maxIterations).setSwarmSize(swarmSize).setRandomGenerator(new MersenneTwisterGenerator()).setSolutionListEvaluator(new SequentialSolutionListEvaluator<DoubleSolution>()).setVariant(SMPSOBuilder.SMPSOVariant.Measures).build();
        MeasureManager measureManager = ((SMPSOMeasures)algorithm).getMeasureManager();
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure("currentPopulation");
        CountingMeasure iterationMeasure = (CountingMeasure)measureManager.getPushMeasure("currentIteration");
        ChartContainer chart = new ChartContainer(algorithm.getName(), 200);
        chart.setFrontChart(0, 1, referenceParetoFront);
        chart.setVarChart(0, 1);
        chart.initChart();
        solutionListMeasure.register(new ChartListener(chart));
        iterationMeasure.register(new IterationListener(chart));
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        chart.saveChart("./chart", BitmapEncoder.BitmapFormat.PNG);
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        SMPSOMeasuresWithChartsRunner.printFinalSolutionSet(population);
        if (!referenceParetoFront.equals("")) {
            SMPSOMeasuresWithChartsRunner.printQualityIndicators(population, referenceParetoFront);
        }
    }

    private static class IterationListener
    implements MeasureListener<Long> {
        ChartContainer chart;

        public IterationListener(ChartContainer chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: 0");
        }

        @Override
        public synchronized void measureGenerated(Long iteration) {
            if (this.chart != null) {
                this.chart.getFrontChart().setTitle("Iteration: " + iteration);
            }
        }
    }

    private static class ChartListener
    implements MeasureListener<List<DoubleSolution>> {
        private ChartContainer chart;
        private int iteration = 0;

        public ChartListener(ChartContainer chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
        }

        private void refreshChart(List<DoubleSolution> solutionList) {
            if (this.chart != null) {
                ++this.iteration;
                this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
                this.chart.updateFrontCharts(solutionList);
                this.chart.refreshCharts();
            }
        }

        @Override
        public synchronized void measureGenerated(List<DoubleSolution> solutions) {
            this.refreshChart(solutions);
        }
    }
}

