/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchart.BitmapEncoder;
import org.uma.jmetal.algorithm.multiobjective.wasfga.WASFGAMeasures;
import org.uma.jmetal.measure.MeasureListener;
import org.uma.jmetal.measure.MeasureManager;
import org.uma.jmetal.measure.impl.BasicMeasure;
import org.uma.jmetal.measure.impl.CountingMeasure;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.chartcontainer.ChartContainer;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class WASFGAMeasuresRunner3D
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, IOException {
        String problemName;
        String referenceParetoFront = "";
        ArrayList<Double> referencePoint = null;
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.dtlz.DTLZ2";
            referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/DTLZ2.3D.pf";
        }
        Problem problem = ProblemUtils.loadProblem(problemName);
        referencePoint = new ArrayList<Double>();
        referencePoint.add(0.0);
        referencePoint.add(0.0);
        referencePoint.add(0.0);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection(new RankingAndCrowdingDistanceComparator());
        double epsilon = 0.01;
        WASFGAMeasures<DoubleSolution> algorithm = new WASFGAMeasures<DoubleSolution>(problem, 100, 250, crossover, mutation, selection, new SequentialSolutionListEvaluator(), epsilon, referencePoint, "MOEAD_Weights/W3D_100.dat");
        MeasureManager measureManager = algorithm.getMeasureManager();
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure("currentPopulation");
        CountingMeasure iterationMeasure = (CountingMeasure)measureManager.getPushMeasure("currentEvaluation");
        ChartContainer chart = new ChartContainer(algorithm.getName(), 200);
        chart.setFrontChart(0, 1, referenceParetoFront);
        chart.setReferencePoint(referencePoint);
        chart.setVarChart(0, 1);
        chart.initChart();
        solutionListMeasure.register(new ChartListener(chart));
        iterationMeasure.register(new IterationListener(chart));
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        chart.saveChart("WASFGA", BitmapEncoder.BitmapFormat.PNG);
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        WASFGAMeasuresRunner3D.printFinalSolutionSet(population);
        if (!referenceParetoFront.equals("")) {
            WASFGAMeasuresRunner3D.printQualityIndicators(population, referenceParetoFront);
        }
    }

    private static class IterationListener
    implements MeasureListener<Long> {
        ChartContainer chart;

        public IterationListener(ChartContainer chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: 0");
        }

        @Override
        public synchronized void measureGenerated(Long iteration) {
            if (this.chart != null) {
                this.chart.getFrontChart().setTitle("Iteration: " + iteration);
            }
        }
    }

    private static class ChartListener
    implements MeasureListener<List<DoubleSolution>> {
        private ChartContainer chart;
        private int iteration = 0;

        public ChartListener(ChartContainer chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
        }

        private void refreshChart(List<DoubleSolution> solutionList) {
            if (this.chart != null) {
                ++this.iteration;
                this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
                this.chart.updateFrontCharts(solutionList);
                this.chart.refreshCharts();
            }
        }

        @Override
        public synchronized void measureGenerated(List<DoubleSolution> solutions) {
            this.refreshChart(solutions);
        }
    }
}

