/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.algorithm.singleobjective.differentialevolution.DifferentialEvolution;
import org.uma.jmetal.algorithm.singleobjective.differentialevolution.DifferentialEvolutionBuilder;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.selection.DifferentialEvolutionSelection;
import org.uma.jmetal.problem.singleobjective.Sphere;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.MultithreadedSolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class DifferentialEvolutionRunner {
    private static final int DEFAULT_NUMBER_OF_CORES = 1;

    public static void main(String[] args) throws Exception {
        Sphere problem = new Sphere(20);
        int numberOfCores = args.length == 1 ? Integer.valueOf(args[0]) : 1;
        SolutionListEvaluator<Object> evaluator = numberOfCores == 1 ? new SequentialSolutionListEvaluator() : new MultithreadedSolutionListEvaluator<DoubleSolution>(numberOfCores, problem);
        DifferentialEvolutionCrossover crossover = new DifferentialEvolutionCrossover(0.5, 0.5, "rand/1/bin");
        DifferentialEvolutionSelection selection = new DifferentialEvolutionSelection();
        DifferentialEvolution algorithm = new DifferentialEvolutionBuilder(problem).setCrossover(crossover).setSelection(selection).setSolutionListEvaluator(evaluator).setMaxEvaluations(25000).setPopulationSize(100).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        DoubleSolution solution = (DoubleSolution)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(1);
        population.add(solution);
        new SolutionListOutput(population).setSeparator("\t").setVarFileOutputContext(new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext(new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
        JMetalLogger.logger.info("Fitness: " + solution.getObjective(0));
        evaluator.shutdown();
    }
}

