/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.singleobjective.geneticalgorithm.GeneticAlgorithmBuilder;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.singleobjective.Sphere;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class GenerationalGeneticAlgorithmDoubleEncodingRunner {
    public static void main(String[] args) throws Exception {
        Sphere problem = new Sphere(20);
        SBXCrossover crossover = new SBXCrossover(0.9, 20.0);
        PolynomialMutation mutation = new PolynomialMutation(1.0 / (double)problem.getNumberOfVariables(), 20.0);
        BinaryTournamentSelection selection = new BinaryTournamentSelection();
        Algorithm<DoubleSolution> algorithm = new GeneticAlgorithmBuilder<DoubleSolution>(problem, crossover, mutation).setPopulationSize(100).setMaxEvaluations(25000).setSelectionOperator(selection).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        DoubleSolution solution = algorithm.getResult();
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(1);
        population.add(solution);
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionListOutput(population).setSeparator("\t").setVarFileOutputContext(new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext(new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
        JMetalLogger.logger.info("Fitness: " + solution.getObjective(0));
    }
}

