/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.algorithm.singleobjective.particleswarmoptimization.StandardPSO2007;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.MultithreadedSolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class StandardPSO2007Runner {
    private static final int DEFAULT_NUMBER_OF_CORES = 1;

    public static void main(String[] args) throws Exception {
        String problemName = "org.uma.jmetal.problem.singleobjective.Sphere";
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem(problemName);
        int numberOfCores = args.length == 1 ? Integer.valueOf(args[0]) : 1;
        SolutionListEvaluator<Object> evaluator = numberOfCores == 1 ? new SequentialSolutionListEvaluator() : new MultithreadedSolutionListEvaluator<DoubleSolution>(numberOfCores, problem);
        StandardPSO2007 algorithm = new StandardPSO2007(problem, 10 + (int)(2.0 * Math.sqrt(problem.getNumberOfVariables())), 25000, 3, evaluator);
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        DoubleSolution solution = (DoubleSolution)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(1);
        population.add(solution);
        new SolutionListOutput(population).setSeparator("\t").setVarFileOutputContext(new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext(new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
        JMetalLogger.logger.info("Fitness: " + solution.getObjective(0));
        JMetalLogger.logger.info("Solution: " + solution.getVariableValueString(0));
        evaluator.shutdown();
    }
}

