/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.singleobjective.geneticalgorithm.GeneticAlgorithmBuilder;
import org.uma.jmetal.operator.impl.crossover.SinglePointCrossover;
import org.uma.jmetal.operator.impl.mutation.BitFlipMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.singleobjective.OneMax;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class SteadyStateGeneticAlgorithmBinaryEncodingRunner {
    public static void main(String[] args) throws Exception {
        OneMax problem = new OneMax(1024);
        SinglePointCrossover crossover = new SinglePointCrossover(0.9);
        double mutationProbability = 1.0 / (double)problem.getNumberOfBits(0);
        BitFlipMutation mutation = new BitFlipMutation(mutationProbability);
        BinaryTournamentSelection selection = new BinaryTournamentSelection();
        Algorithm<BinarySolution> algorithm = new GeneticAlgorithmBuilder<BinarySolution>(problem, crossover, mutation).setPopulationSize(50).setMaxEvaluations(25000).setSelectionOperator(selection).setVariant(GeneticAlgorithmBuilder.GeneticAlgorithmVariant.STEADY_STATE).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        long computingTime = algorithmRunner.getComputingTime();
        BinarySolution solution = algorithm.getResult();
        ArrayList<BinarySolution> population = new ArrayList<BinarySolution>(1);
        population.add(solution);
        new SolutionListOutput(population).setSeparator("\t").setVarFileOutputContext(new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext(new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
        JMetalLogger.logger.info("Fitness: " + solution.getObjective(0));
        JMetalLogger.logger.info("Solution: " + solution.getVariableValueString(0));
    }
}

