/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.BitSet;
import java.util.HashMap;
import org.uma.jmetal.problem.DoubleBinaryProblem;
import org.uma.jmetal.solution.DoubleBinarySolution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;

public class DefaultDoubleBinarySolution
extends AbstractGenericSolution<Object, DoubleBinaryProblem<?>>
implements DoubleBinarySolution {
    private int numberOfDoubleVariables;

    public DefaultDoubleBinarySolution(DoubleBinaryProblem<?> problem) {
        super(problem);
        this.numberOfDoubleVariables = problem.getNumberOfDoubleVariables();
        this.initializeDoubleVariables();
        this.initializeBitSet();
        this.initializeObjectiveValues();
    }

    public DefaultDoubleBinarySolution(DefaultDoubleBinarySolution solution) {
        super(solution.problem);
        for (int i = 0; i < ((DoubleBinaryProblem)this.problem).getNumberOfObjectives(); ++i) {
            this.setObjective(i, solution.getObjective(i));
        }
        this.copyDoubleVariables(solution);
        this.copyBitSet(solution);
        this.attributes = new HashMap(solution.attributes);
    }

    private void initializeDoubleVariables() {
        for (int i = 0; i < this.numberOfDoubleVariables; ++i) {
            Double value = this.randomGenerator.nextDouble(this.getLowerBound(i), this.getUpperBound(i));
            this.setVariableValue(i, value);
        }
    }

    private void initializeBitSet() {
        BitSet bitset = this.createNewBitSet(((DoubleBinaryProblem)this.problem).getNumberOfBits());
        this.setVariableValue(this.numberOfDoubleVariables, bitset);
    }

    private void copyDoubleVariables(DefaultDoubleBinarySolution solution) {
        for (int i = 0; i < this.numberOfDoubleVariables; ++i) {
            this.setVariableValue(i, solution.getVariableValue(i));
        }
    }

    private void copyBitSet(DefaultDoubleBinarySolution solution) {
        BitSet bitset = (BitSet)solution.getVariableValue(solution.getNumberOfVariables() - 1);
        this.setVariableValue(this.numberOfDoubleVariables, bitset);
    }

    @Override
    public int getNumberOfDoubleVariables() {
        return this.numberOfDoubleVariables;
    }

    @Override
    public Double getUpperBound(int index) {
        return (Double)((DoubleBinaryProblem)this.problem).getUpperBound(index);
    }

    @Override
    public int getNumberOfBits() {
        return ((DoubleBinaryProblem)this.problem).getNumberOfBits();
    }

    @Override
    public Double getLowerBound(int index) {
        return (Double)((DoubleBinaryProblem)this.problem).getLowerBound(index);
    }

    public DefaultDoubleBinarySolution copy() {
        return new DefaultDoubleBinarySolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        return this.getVariableValue(index).toString();
    }

    private BitSet createNewBitSet(int numberOfBits) {
        BitSet bitSet = new BitSet(numberOfBits);
        for (int i = 0; i < numberOfBits; ++i) {
            if (this.randomGenerator.nextDouble() < 0.5) {
                bitSet.set(i, true);
                continue;
            }
            bitSet.set(i, false);
        }
        return bitSet;
    }
}

